/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.util;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.AbstractFormatValidator;
import org.apache.commons.validator.routines.BigDecimalValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.daikon.number.BigDecimalParser;

public class NumericHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(NumericHelper.class);
    private static final Locale[] LOCALES = new Locale[]{Locale.FRENCH, Locale.ENGLISH};
    private static final char[] ALLOWED_NUMERIC_CHARACTERS = new char[]{',', '.', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '+', 'E', 'e', ' ', '\'', '%'};

    private NumericHelper() {
    }

    private static boolean isValid(String str, AbstractFormatValidator validator) {
        for (Locale locale : LOCALES) {
            if (!validator.isValid(str, locale)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBigDecimal(String str) {
        DecimalFormat[] supportedFormats;
        if (StringUtils.isEmpty((String)str)) {
            return false;
        }
        String strForValidation = StringUtils.remove((String)str, (char)' ');
        if (StringUtils.isEmpty((String)strForValidation)) {
            return false;
        }
        if (strForValidation.lastIndexOf(40) == 0 && strForValidation.lastIndexOf(41) == strForValidation.length() - 1) {
            strForValidation = strForValidation.substring(1, strForValidation.length() - 1);
        }
        if (!StringUtils.containsOnly((String)strForValidation, (char[])ALLOWED_NUMERIC_CHARACTERS) && !NumericHelper.isValid(strForValidation, (AbstractFormatValidator)new BigDecimalValidator())) {
            return false;
        }
        if (strForValidation.charAt(0) == ',' || strForValidation.charAt(0) == '.') {
            return true;
        }
        for (DecimalFormat supportedFormat : supportedFormats = new DecimalFormat[]{BigDecimalParser.EU_DECIMAL_PATTERN, BigDecimalParser.EU_SCIENTIFIC_DECIMAL_PATTERN, BigDecimalParser.US_DECIMAL_PATTERN, BigDecimalParser.US_SCIENTIFIC_DECIMAL_PATTERN}) {
            try {
                if (supportedFormat.parse(strForValidation) == null) continue;
                return true;
            }
            catch (ParseException e) {
                LOGGER.debug("Unable to parse '{}' using custom decimal format '{}'.", new Object[]{strForValidation, supportedFormat.toPattern(), e});
            }
        }
        return false;
    }
}

