/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.actions;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.apache.avro.generic.IndexedRecord;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.ClassPathActionRegistry;
import org.talend.dataprep.actions.ActionParser;
import org.talend.dataprep.actions.RemoteResourceGetter;
import org.talend.dataprep.actions.StandalonePreparationFactory;
import org.talend.dataprep.actions.resources.DictionaryFunctionResourceProvider;
import org.talend.dataprep.actions.resources.FunctionResourceProvider;
import org.talend.dataprep.actions.resources.LookupFunctionResourceProvider;
import org.talend.dataprep.transformation.pipeline.ActionRegistry;

public class DefaultActionParser
implements ActionParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultActionParser.class);
    private static final ActionRegistry actionRegistry = new ClassPathActionRegistry(new String[]{"org.talend.dataprep.transformation.actions"});
    private final String apiUrl;
    private final String login;
    private final String password;
    private final FunctionResourceProvider[] providers;
    private boolean allowNonDistributedActions = false;

    public DefaultActionParser(String apiUrl, String login, String password) {
        this.apiUrl = apiUrl;
        this.login = login;
        this.password = password;
        this.providers = new FunctionResourceProvider[]{new LookupFunctionResourceProvider(apiUrl, login, password), new DictionaryFunctionResourceProvider(actionRegistry, apiUrl, login, password)};
    }

    public void setAllowNonDistributedActions(boolean allowNonDistributedActions) {
        this.allowNonDistributedActions = allowNonDistributedActions;
    }

    private String getPreparation(RemoteResourceGetter clientFormLogin, String preparationId, String versionId) {
        LOGGER.debug("Retrieving preparation '{}' version '{}'", (Object)preparationId, (Object)(versionId == null ? "head" : versionId));
        return clientFormLogin.retrievePreparation(this.apiUrl, this.login, this.password, preparationId, versionId);
    }

    private Function<IndexedRecord, IndexedRecord> internalParse(InputStream preparation) {
        StandalonePreparationFactory transformer = new StandalonePreparationFactory();
        transformer.setAllowNonDistributedActions(this.allowNonDistributedActions);
        return transformer.create(preparation, this.providers);
    }

    @Override
    public Function<IndexedRecord, IndexedRecord> parse(String preparationId) {
        return this.parse(preparationId, null);
    }

    @Override
    public Function<IndexedRecord, IndexedRecord> parse(String preparationId, String versionId) {
        RemoteResourceGetter clientFormLogin = new RemoteResourceGetter();
        String preparation = this.getPreparation(clientFormLogin, preparationId, versionId);
        return this.internalParse(IOUtils.toInputStream((String)preparation, (Charset)StandardCharsets.UTF_8));
    }
}

