/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.actions.DPErrorCode;
import org.talend.dataprep.api.dataset.DataSetDataReader;
import org.talend.dataprep.api.dataset.row.LightweightExportableDataSet;
import org.talend.dataquality.semantic.broadcast.TdqCategories;

public class RemoteResourceGetter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteResourceGetter.class);
    private final CloseableHttpClient client = HttpClients.custom().build();
    private final ObjectMapper mapper = new ObjectMapper();
    private final DataSetDataReader dataSetDataReader = new DataSetDataReader(this.mapper);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Header login(String url, String userName, String passWord) {
        URI uri;
        try {
            uri = new URI(url + "/login?client-app=STUDIO");
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The provided url is not correct: " + url, e);
        }
        HttpUriRequest login = RequestBuilder.post().setUri(uri).addParameter("username", userName).addParameter("password", passWord).build();
        try (CloseableHttpResponse response = this.client.execute(login);){
            Header[] headers;
            this.handleError((HttpResponse)response);
            Header[] headerArray = headers = response.getAllHeaders();
            int n = headerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                if (StringUtils.equalsIgnoreCase((String)"Authorization", (String)header.getName())) {
                    Header header2 = header;
                    return header2;
                }
                ++n2;
            }
            throw new RemoteConnectionException("The Authorization header is absent from the response when trying to connect to: " + url);
        }
        catch (IOException e) {
            throw new RemoteConnectionException("Unable to log with the specified url", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LightweightExportableDataSet mapLookupDataSet(String apiUrl, Header jwt, String dataSetId, String joinOnColumn) {
        String url = apiUrl + "/api/datasets/" + dataSetId + "?fullContent=true&includeTechnicalProperties=true";
        HttpGet request = new HttpGet(url);
        request.addHeader(jwt);
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
            this.handleError((HttpResponse)response);
            LightweightExportableDataSet lightweightExportableDataSet = this.dataSetDataReader.parseAndMapLookupDataSet(response.getEntity().getContent(), joinOnColumn);
            return lightweightExportableDataSet;
        }
        catch (IOException | IllegalArgumentException e) {
            throw new RemoteConnectionException("Unable to retrieve the lookup dataset: " + dataSetId, e);
        }
    }

    public LightweightExportableDataSet retrieveLookupDataSet(String apiUrl, String login, String password, String dataSetId, String joinOnColumn) {
        Header jwt = this.login(apiUrl, login, password);
        return this.mapLookupDataSet(apiUrl, jwt, dataSetId, joinOnColumn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TdqCategories retrieveDictionaries(String apiUrl, String login, String password) {
        String url = apiUrl + "/api/transform/dictionary";
        HttpGet request = new HttpGet(url);
        request.addHeader(this.login(apiUrl, login, password));
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
            this.handleError((HttpResponse)response);
            ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(response.getEntity().getContent()));
            Object object = ois.readObject();
            TdqCategories tdqCategories = (TdqCategories)object;
            return tdqCategories;
        }
        catch (Exception e) {
            throw new RemoteConnectionException("Unable to retrieve dictionaries.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String retrievePreparation(String apiUrl, String login, String password, String preparationId, String versionId) {
        Header jwt = this.login(apiUrl, login, password);
        String url = apiUrl + "/api/preparations/" + preparationId;
        if (StringUtils.isNotBlank((String)versionId)) {
            url = url + "/versions/" + versionId;
        }
        url = url + "/details";
        HttpGet request = new HttpGet(url);
        request.addHeader(jwt);
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);){
            this.handleError((HttpResponse)response);
            String string = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new RemoteConnectionException("Unable to retrieve the preparation with id: " + preparationId, e);
        }
    }

    void handleError(HttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            try {
                DPErrorCode errorCode = (DPErrorCode)this.mapper.readValue(response.getEntity().getContent(), DPErrorCode.class);
                throw new RemoteConnectionException("Status Code: " + statusCode + ", cause: " + errorCode.getCause() + ", message: " + errorCode.getMessage() + ".");
            }
            catch (IOException e) {
                LOGGER.debug("Communication error with server.", (Throwable)e);
                throw new RemoteConnectionException("Status Code: " + statusCode + ", cause: " + response.getStatusLine().getReasonPhrase() + ".");
            }
        }
    }

    public static class RemoteConnectionException
    extends RuntimeException {
        RemoteConnectionException(String message) {
            super(message);
        }

        RemoteConnectionException(String message, Throwable e) {
            super(message, e);
        }
    }
}

