/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.actions.resources;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.actions.RemoteResourceGetter;
import org.talend.dataprep.actions.resources.DictionaryResource;
import org.talend.dataprep.actions.resources.FunctionResource;
import org.talend.dataprep.actions.resources.FunctionResourceProvider;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.preparation.Action;
import org.talend.dataprep.transformation.actions.common.RunnableAction;
import org.talend.dataprep.transformation.pipeline.ActionRegistry;
import org.talend.dataquality.semantic.broadcast.TdqCategories;

public class DictionaryFunctionResourceProvider
implements FunctionResourceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DictionaryFunctionResourceProvider.class);
    private final ActionRegistry actionRegistry;
    private final String apiUrl;
    private final String login;
    private final String password;

    public DictionaryFunctionResourceProvider(ActionRegistry actionRegistry, String apiUrl, String login, String password) {
        this.actionRegistry = actionRegistry;
        this.apiUrl = apiUrl;
        this.login = login;
        this.password = password;
    }

    private TdqCategories retrieveDictionaries(List<RunnableAction> actions) {
        boolean requireDictionary = false;
        for (Action action : actions) {
            ActionDefinition actionDefinition = this.actionRegistry.get(action.getName());
            if (!actionDefinition.getBehavior().contains(ActionDefinition.Behavior.NEED_STATISTICS_INVALID)) continue;
            LOGGER.info("Action '{}' requires up to date dictionary.", (Object)actionDefinition.getName());
            requireDictionary = true;
            break;
        }
        if (requireDictionary) {
            RemoteResourceGetter getter = new RemoteResourceGetter();
            LOGGER.info("Retrieving dictionary from Data Prep...");
            TdqCategories tdqCategories = getter.retrieveDictionaries(this.apiUrl, this.login, this.password);
            LOGGER.info("Dictionary retrieved.");
            return tdqCategories;
        }
        return null;
    }

    @Override
    public FunctionResource get(List<RunnableAction> actions) {
        return new DictionaryResource(this.retrieveDictionaries(actions));
    }
}

