/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.actions.resources;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.actions.resources.FunctionResource;
import org.talend.dataprep.quality.AnalyzerService;
import org.talend.dataprep.transformation.actions.Providers;
import org.talend.dataquality.semantic.broadcast.TdqCategories;
import org.talend.dataquality.semantic.recognizer.CategoryRecognizerBuilder;

public class DictionaryResource
implements FunctionResource {
    private final TdqCategories tdqCategories;
    private static final Logger LOGGER = LoggerFactory.getLogger(DictionaryResource.class);

    public DictionaryResource(TdqCategories tdqCategories) {
        this.tdqCategories = tdqCategories;
    }

    @Override
    public void register() {
        if (this.tdqCategories != null) {
            LOGGER.info("registering dictionary resources into AnalyzerService...");
            CategoryRecognizerBuilder builder = CategoryRecognizerBuilder.newBuilder().lucene();
            if (this.tdqCategories.getDictionary() != null) {
                builder = builder.ddDirectory(this.tdqCategories.getDictionary().asDirectory());
            }
            if (this.tdqCategories.getCustomDictionary() != null) {
                builder = builder.ddCustomDirectory(this.tdqCategories.getCustomDictionary().asDirectory());
            }
            if (this.tdqCategories.getKeyword() != null) {
                builder = builder.kwDirectory(this.tdqCategories.getKeyword().asDirectory());
            }
            if (this.tdqCategories.getRegex() != null) {
                builder = builder.regexClassifier(this.tdqCategories.getRegex().getRegexClassifier());
            }
            if (this.tdqCategories.getCategoryMetadata() != null) {
                builder = builder.metadata(this.tdqCategories.getCategoryMetadata().getMetadata());
            }
            ((AnalyzerService)Providers.get(AnalyzerService.class)).setCategoryRecognizerBuilder(builder);
        }
    }
}

