/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.actions.resources;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.actions.resources.FunctionResource;
import org.talend.dataprep.api.dataset.row.LightweightExportableDataSet;
import org.talend.dataprep.transformation.actions.datablending.LookupDatasetsManager;

public class LookupResource
implements FunctionResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(LookupResource.class);
    private final Map<String, LightweightExportableDataSet> lookupDataSets;

    public LookupResource(Map<String, LightweightExportableDataSet> lookupDataSets) {
        this.lookupDataSets = lookupDataSets;
    }

    @Override
    public void register() {
        LOGGER.debug("Adding cached data sets to LookupDataSetManager");
        this.lookupDataSets.entrySet().forEach(entry -> {
            if (LookupDatasetsManager.put((String)((String)entry.getKey()), (LightweightExportableDataSet)((LightweightExportableDataSet)entry.getValue()))) {
                LOGGER.debug("Added {} to the lookup data sets", entry.getKey());
            }
        });
    }
}

