/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.actions;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.actions.StackedNode;
import org.talend.dataprep.actions.resources.FunctionResource;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.transformation.pipeline.Pipeline;

class SerializableFunction
implements Function<IndexedRecord, IndexedRecord>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(SerializableFunction.class);
    private final Pipeline pipeline;
    private final StackedNode stackedNode;
    private final RowMetadata initialRowMetadata;
    private final FunctionResource[] resources;
    private transient boolean loaded = false;
    private transient long count = 0L;
    private transient Schema outputSchema;

    SerializableFunction(Pipeline pipeline, StackedNode stackedNode, RowMetadata initialRowMetadata, FunctionResource ... resources) {
        this.pipeline = pipeline;
        this.stackedNode = stackedNode;
        this.initialRowMetadata = initialRowMetadata;
        this.resources = resources;
    }

    @Override
    public IndexedRecord apply(IndexedRecord indexedRecord) {
        if (!this.loaded) {
            for (FunctionResource resource : this.resources) {
                LOG.debug("Loading resource '{}'...", (Object)resource);
                resource.register();
            }
            this.loaded = true;
        }
        if (this.count++ % 10000L == 0L) {
            LOG.debug("Current pipeline state: " + this.pipeline);
        }
        HashMap<String, String> values = new HashMap<String, String>();
        List fields = indexedRecord.getSchema().getFields();
        DecimalFormat decimalFormat = new DecimalFormat("0000");
        int i = 0;
        for (Schema.Field field : fields) {
            values.put(decimalFormat.format(i++), String.valueOf(indexedRecord.get(field.pos())));
        }
        DataSetRow row = new DataSetRow(values);
        this.pipeline.receive(row, this.initialRowMetadata);
        Optional<DataSetRow> result = Optional.ofNullable(this.stackedNode.pop());
        if (result.isPresent()) {
            DataSetRow modifiedRow = result.get();
            this.initializeSchema(modifiedRow);
            GenericData.Record modifiedRecord = new GenericData.Record(this.outputSchema);
            Iterator iterator = modifiedRow.order().values().values().iterator();
            for (int j = 0; j < this.outputSchema.getFields().size() && iterator.hasNext(); ++j) {
                modifiedRecord.put(j, iterator.next());
            }
            return modifiedRecord;
        }
        return null;
    }

    private void initializeSchema(DataSetRow modifiedRow) {
        if (this.outputSchema == null) {
            RowMetadata modifiedRowRowMetadata = modifiedRow.getRowMetadata();
            this.outputSchema = RowMetadataUtils.toSchema((RowMetadata)modifiedRowRowMetadata);
        }
    }
}

