/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.actions;

import java.util.ArrayDeque;
import java.util.Deque;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.transformation.pipeline.Monitored;
import org.talend.dataprep.transformation.pipeline.Node;
import org.talend.dataprep.transformation.pipeline.node.BasicNode;

class StackedNode
extends BasicNode
implements Monitored {
    private static final long serialVersionUID = 1L;
    private transient Deque<DataSetRow> stack;
    private long totalTime;
    private long count;

    StackedNode() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(DataSetRow row, RowMetadata metadata) {
        long start = System.currentTimeMillis();
        try {
            if (!row.isDeleted()) {
                this.getStack().push(row);
            }
            super.receive(row, metadata);
        }
        finally {
            this.totalTime += System.currentTimeMillis() - start;
            ++this.count;
        }
    }

    private Deque<DataSetRow> getStack() {
        if (this.stack == null) {
            this.stack = new ArrayDeque<DataSetRow>();
        }
        return this.stack;
    }

    DataSetRow pop() {
        Deque<DataSetRow> dataSetRows = this.getStack();
        return dataSetRows.isEmpty() ? null : dataSetRows.pop();
    }

    public Node copyShallow() {
        return new StackedNode();
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public long getCount() {
        return this.count;
    }
}

