/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.actions;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.avro.generic.IndexedRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.PreparationParser;
import org.talend.dataprep.StandalonePreparation;
import org.talend.dataprep.actions.SerializableFunction;
import org.talend.dataprep.actions.StackedNode;
import org.talend.dataprep.actions.resources.DictionaryResource;
import org.talend.dataprep.actions.resources.FunctionResource;
import org.talend.dataprep.actions.resources.FunctionResourceProvider;
import org.talend.dataprep.actions.resources.LookupResource;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.filter.FilterService;
import org.talend.dataprep.api.filter.PolyglotFilterService;
import org.talend.dataprep.dataset.StatisticsAdapter;
import org.talend.dataprep.quality.AnalyzerService;
import org.talend.dataprep.transformation.actions.Providers;
import org.talend.dataprep.transformation.pipeline.Pipeline;

public class StandalonePreparationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandalonePreparationFactory.class);
    private boolean allowNonDistributedActions = false;

    public void setAllowNonDistributedActions(boolean allowNonDistributedActions) {
        this.allowNonDistributedActions = allowNonDistributedActions;
    }

    public Function<IndexedRecord, IndexedRecord> create(InputStream preparation, FunctionResource ... resources) {
        StandalonePreparation minimalPreparation = PreparationParser.parsePreparation((InputStream)preparation);
        return this.create(minimalPreparation, resources);
    }

    public Function<IndexedRecord, IndexedRecord> create(InputStream preparation, FunctionResourceProvider ... providers) {
        StandalonePreparation minimalPreparation = PreparationParser.parsePreparation((InputStream)preparation);
        return this.create(minimalPreparation, providers);
    }

    public Function<IndexedRecord, IndexedRecord> create(StandalonePreparation preparation, FunctionResourceProvider ... providers) {
        if (preparation.getActions() == null) {
            LOGGER.info("No action defined in preparation, returning identity function");
            return new NoOpFunction();
        }
        List actions = PreparationParser.ensureActionRowsExistence((List)preparation.getActions(), (boolean)this.allowNonDistributedActions);
        FunctionResource[] resources = Arrays.stream(providers).map(provider -> provider.get(actions)).collect(Collectors.toList()).toArray(new FunctionResource[providers.length]);
        return this.create(preparation, resources);
    }

    public Function<IndexedRecord, IndexedRecord> create(StandalonePreparation preparation, FunctionResource ... resources) {
        if (preparation.getActions() == null) {
            LOGGER.info("No action defined in preparation, returning identity function");
            return new NoOpFunction();
        }
        RowMetadata rowMetadata = preparation.getRowMetadata();
        List actions = PreparationParser.ensureActionRowsExistence((List)preparation.getActions(), (boolean)this.allowNonDistributedActions);
        LOGGER.trace("The initial row metadata is: " + rowMetadata);
        StackedNode stackedNode = new StackedNode();
        Pipeline pipeline = Pipeline.Builder.builder().withActionRegistry(PreparationParser.actionRegistry).withActions(actions).withFilterOut((Function)new FilterOutProvider(preparation)).withInitialMetadata(rowMetadata, true).withOutput(() -> stackedNode).withStatisticsAdapter(new StatisticsAdapter(40)).withGlobalStatistics(false).allowMetadataChange(false).withAnalyzerService((AnalyzerService)Providers.get(AnalyzerService.class)).build();
        return new SerializableFunction(pipeline, stackedNode, rowMetadata, resources);
    }

    public Function<IndexedRecord, IndexedRecord> create(InputStream inputStream) {
        StandalonePreparation standalonePreparation = PreparationParser.parsePreparation((InputStream)inputStream);
        LookupResource lookup = new LookupResource(standalonePreparation.getLookupDataSets());
        DictionaryResource dictionary = new DictionaryResource(standalonePreparation.getTdqCategories());
        return this.create(standalonePreparation, lookup, dictionary);
    }

    static class FilterOutProvider
    implements Function<RowMetadata, Predicate<DataSetRow>>,
    Serializable {
        private final StandalonePreparation preparation;

        FilterOutProvider(StandalonePreparation preparation) {
            this.preparation = preparation;
        }

        @Override
        public Predicate<DataSetRow> apply(RowMetadata metadata) {
            FilterService filterService = (FilterService)Providers.get(PolyglotFilterService.class);
            return filterService.build(this.preparation.getFilterOut(), metadata);
        }
    }

    static class NoOpFunction
    implements Function<IndexedRecord, IndexedRecord>,
    Serializable {
        NoOpFunction() {
        }

        @Override
        public IndexedRecord apply(IndexedRecord indexedRecord) {
            return indexedRecord;
        }
    }
}

