/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.actions.resources;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.actions.resources.FunctionResource;
import org.talend.dataprep.quality.AnalyzerService;
import org.talend.dataprep.transformation.actions.Providers;
import org.talend.dataquality.semantic.broadcast.TdqCategories;
import org.talend.dataquality.semantic.snapshot.BroadcastDictionarySnapshotProvider;
import org.talend.dataquality.semantic.snapshot.DictionarySnapshotProvider;

public class DictionaryResource
implements FunctionResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DictionaryResource.class);
    private final TdqCategories tdqCategories;

    public DictionaryResource(TdqCategories tdqCategories) {
        this.tdqCategories = tdqCategories;
    }

    @Override
    public void register() {
        if (this.tdqCategories != null) {
            LOGGER.info("registering dictionary resources into AnalyzerService...");
            AnalyzerService analyzerService = (AnalyzerService)Providers.get(AnalyzerService.class);
            analyzerService.setDictionarySnapshotProvider((DictionarySnapshotProvider)new BroadcastDictionarySnapshotProvider(this.tdqCategories.asDictionarySnapshot()));
        }
    }
}

