/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.actions.resources;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.actions.RemoteResourceGetter;
import org.talend.dataprep.actions.resources.FunctionResource;
import org.talend.dataprep.actions.resources.FunctionResourceProvider;
import org.talend.dataprep.actions.resources.LookupResource;
import org.talend.dataprep.api.dataset.row.LightweightExportableDataSet;
import org.talend.dataprep.api.preparation.Action;
import org.talend.dataprep.transformation.actions.common.RunnableAction;
import org.talend.dataprep.transformation.actions.datablending.Lookup;

public class LookupFunctionResourceProvider
implements FunctionResourceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(LookupFunctionResourceProvider.class);
    private final String apiUrl;
    private final String login;
    private final String password;

    public LookupFunctionResourceProvider(String apiUrl, String login, String password) {
        this.apiUrl = apiUrl;
        this.login = login;
        this.password = password;
    }

    private LightweightExportableDataSet getLookupDataset(RemoteResourceGetter clientFormLogin, String dataSetId, String joinOnColumn) {
        LOGGER.debug("Retrieving lookup dataset '{}'", (Object)dataSetId);
        return clientFormLogin.retrieveLookupDataSet(this.apiUrl, this.login, this.password, dataSetId, joinOnColumn);
    }

    public LightweightExportableDataSet retrieveLookupDataSetFromAction(RemoteResourceGetter clientFormLogin, Action action) {
        String dataSetId;
        if (StringUtils.equals((String)action.getName(), (String)"lookup")) {
            dataSetId = (String)action.getParameters().get(Lookup.Parameters.LOOKUP_DS_ID.getKey());
            if (StringUtils.isEmpty((String)dataSetId)) {
                throw new IllegalArgumentException("A lookup action must have a lookup dataset id: " + action);
            }
        } else {
            throw new IllegalArgumentException("Trying to retrieve a lookup dataset from the following action: " + action.getName());
        }
        String joinOn = (String)action.getParameters().get(Lookup.Parameters.LOOKUP_JOIN_ON.getKey());
        LightweightExportableDataSet result = this.getLookupDataset(clientFormLogin, dataSetId, joinOn);
        return result;
    }

    public Map<String, LightweightExportableDataSet> retrieveLookupDataSets(List<RunnableAction> actions) {
        HashMap<String, LightweightExportableDataSet> result = new HashMap<String, LightweightExportableDataSet>();
        RemoteResourceGetter clientFormLogin = new RemoteResourceGetter();
        actions.stream().filter(action -> StringUtils.equals((String)action.getName(), (String)"lookup")).forEach(action -> {
            LightweightExportableDataSet lookup = this.retrieveLookupDataSetFromAction(clientFormLogin, (Action)action);
            result.put((String)action.getParameters().get(Lookup.Parameters.LOOKUP_DS_ID.getKey()), lookup);
        });
        return result;
    }

    @Override
    public FunctionResource get(List<RunnableAction> actions) {
        return new LookupResource(this.retrieveLookupDataSets(actions));
    }
}

