/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.ActionParser;
import org.talend.dataprep.ClassPathActionRegistry;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.filter.FilterService;
import org.talend.dataprep.api.filter.SimpleFilterService;
import org.talend.dataprep.api.preparation.Action;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.dataset.StatisticsAdapter;
import org.talend.dataprep.transformation.actions.common.ActionFactory;
import org.talend.dataprep.transformation.actions.common.IActionFactory;
import org.talend.dataprep.transformation.api.action.context.ActionContext;
import org.talend.dataprep.transformation.api.action.context.TransformationContext;
import org.talend.dataprep.transformation.api.action.validation.ActionMetadataValidation;
import org.talend.dataprep.transformation.pipeline.ActionRegistry;
import org.talend.dataprep.transformation.pipeline.Pipeline;
import org.talend.dataprep.transformation.pipeline.node.BasicNode;

public class DefaultActionParser
implements ActionParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultActionParser.class);
    private static final String COLUMN_NAME_PARAMETER = "column_name";
    private static final ActionRegistry actionRegistry = new ClassPathActionRegistry(new String[]{"org.talend.dataprep.transformation.actions"});
    private static final IActionFactory actionFactory = new ActionFactory(new ActionMetadataValidation(), (FilterService)new SimpleFilterService());

    private static void assertActions(Object actions) {
        if (actions == null) {
            throw new IllegalArgumentException("Actions can not be null.");
        }
    }

    private static List<Action> getActions(InputStream actionsAsString) {
        DefaultActionParser.assertActions(actionsAsString);
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode jsonNode = mapper.readTree(actionsAsString);
            JsonNode actionsArrayStart = jsonNode.get("actions");
            if (actionsArrayStart == null) {
                LOGGER.warn("No 'actions' field in JSON, consider input as empty.");
                return Collections.emptyList();
            }
            if (!actionsArrayStart.isArray()) {
                throw new IllegalArgumentException("Expected array at stream start");
            }
            ArrayList<Action> parsedActions = new ArrayList<Action>();
            actionsArrayStart.elements().forEachRemaining(n -> {
                String actionName = n.get("action").asText();
                LOGGER.info("New action: {}", (Object)actionName);
                ActionDefinition actionMetadata = actionRegistry.get(actionName);
                if (actionMetadata == null) {
                    LOGGER.error("No action implementation found for '{}'.", (Object)actionName);
                } else {
                    LOGGER.info("Action metadata found for '{}': {}", (Object)actionName, (Object)actionMetadata.getClass().getName());
                    Iterator parameters = n.get("parameters").fields();
                    HashMap parametersAsMap = new HashMap();
                    while (parameters.hasNext()) {
                        Map.Entry next = (Map.Entry)parameters.next();
                        JsonNode value = (JsonNode)next.getValue();
                        if (value.isTextual()) {
                            parametersAsMap.put(next.getKey(), value.asText());
                            continue;
                        }
                        if (value.isObject()) {
                            parametersAsMap.put(next.getKey(), value.toString());
                            continue;
                        }
                        LOGGER.warn("Unknown JSON node type in parameters '{}', falls back to asText().", (Object)value);
                        parametersAsMap.put(next.getKey(), value.asText());
                    }
                    Action action = actionFactory.create(actionMetadata, parametersAsMap);
                    LOGGER.info("Wrap action execution for '{}' with parameters '{}'.", (Object)actionMetadata.getClass().getName(), parametersAsMap);
                    ActionContext context = new ActionContext(new TransformationContext());
                    context.setParameters(parametersAsMap);
                    parsedActions.add(action);
                    LOGGER.info("Action added: {}", (Object)actionName);
                }
            });
            return parsedActions;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid action list", e);
        }
    }

    private static Function<IndexedRecord, IndexedRecord> internalParse(InputStream actions, Schema inputSchema) {
        DefaultActionParser.assertActions(actions);
        RowMetadata rowMetadata = new RowMetadata();
        try {
            List fields = inputSchema.getFields();
            for (Schema.Field field : fields) {
                ColumnMetadata newColumn = ColumnMetadata.Builder.column().name(field.name()).type(Type.get((String)field.schema().getType().getName().toLowerCase())).build();
                rowMetadata.addColumn(newColumn);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Invalid schema as input, consider empty schema.", (Throwable)e);
        }
        StackedNode stackedNode = new StackedNode();
        Pipeline pipeline = Pipeline.Builder.builder().withActionRegistry(actionRegistry).withActions(DefaultActionParser.getActions(actions)).withInitialMetadata(rowMetadata, true).withOutput(() -> stackedNode).withStatisticsAdapter(new StatisticsAdapter(40)).withGlobalStatistics(false).allowMetadataChange(false).build();
        return new SerializableFunction(pipeline, stackedNode, rowMetadata);
    }

    @Override
    public Function<IndexedRecord, IndexedRecord> parse(String actions, String encoding, Schema inputSchema) throws UnsupportedEncodingException {
        DefaultActionParser.assertActions(actions);
        return this.parse(new ByteArrayInputStream(actions.getBytes(encoding)), inputSchema);
    }

    @Override
    public Function<IndexedRecord, IndexedRecord> parse(InputStream actions, Schema inputSchema) {
        return DefaultActionParser.internalParse(actions, inputSchema);
    }

    private static class SerializableFunction
    implements Function<IndexedRecord, IndexedRecord>,
    Serializable {
        private final Pipeline pipeline;
        private final StackedNode stackedNode;
        private final RowMetadata initialRowMetadata;

        private SerializableFunction(Pipeline pipeline, StackedNode stackedNode, RowMetadata initialRowMetadata) {
            this.pipeline = pipeline;
            this.stackedNode = stackedNode;
            this.initialRowMetadata = initialRowMetadata;
        }

        @Override
        public IndexedRecord apply(IndexedRecord indexedRecord) {
            HashMap<String, String> values = new HashMap<String, String>();
            List fields = indexedRecord.getSchema().getFields();
            DecimalFormat decimalFormat = new DecimalFormat("0000");
            int i = 0;
            for (Schema.Field field : fields) {
                values.put(decimalFormat.format(i++), String.valueOf(indexedRecord.get(field.pos())));
            }
            DataSetRow row = new DataSetRow(values);
            this.pipeline.receive(row, this.initialRowMetadata);
            Optional<DataSetRow> result = Optional.ofNullable(this.stackedNode.pop());
            if (result.isPresent()) {
                DataSetRow modifiedRow = result.get();
                RowMetadata modifiedRowRowMetadata = modifiedRow.getRowMetadata();
                Schema outputSchema = RowMetadataUtils.toSchema((RowMetadata)modifiedRowRowMetadata);
                GenericData.Record modifiedRecord = new GenericData.Record(outputSchema);
                Iterator iterator = modifiedRow.order().values().values().iterator();
                for (int j = 0; j < outputSchema.getFields().size() && iterator.hasNext(); ++j) {
                    modifiedRecord.put(j, iterator.next());
                }
                return modifiedRecord;
            }
            return null;
        }
    }

    private static class StackedNode
    extends BasicNode {
        private transient Deque<DataSetRow> stack = new ArrayDeque<DataSetRow>();

        private StackedNode() {
        }

        public void receive(DataSetRow row, RowMetadata metadata) {
            if (!row.isDeleted()) {
                this.getStack().push(row);
            }
            super.receive(row, metadata);
        }

        private Deque<DataSetRow> getStack() {
            if (this.stack == null) {
                this.stack = new ArrayDeque<DataSetRow>();
            }
            return this.stack;
        }

        DataSetRow pop() {
            Deque<DataSetRow> dataSetRows = this.getStack();
            return dataSetRows.isEmpty() ? null : dataSetRows.pop();
        }
    }
}

