/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.common.inference;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.apache.log4j.Logger;
import org.talend.dataquality.common.inference.Analyzer;
import org.talend.dataquality.common.inference.ResizableList;

public class Analyzers
implements Analyzer<Result> {
    private static final long serialVersionUID = 3718737129904789140L;
    private static final Logger LOGGER = Logger.getLogger(Analyzers.class);
    private final Analyzer<?>[] analyzerArrays;
    private final ResizableList<Result> results = new ResizableList<Result>(Result.class);

    private Analyzers(Analyzer<?> ... analyzers) {
        this.analyzerArrays = analyzers;
    }

    public static Analyzer<Result> with(Analyzer<?> ... analyzers) {
        return new Analyzers(analyzers);
    }

    @Override
    public void init() {
        for (Analyzer<?> analyzer : this.analyzerArrays) {
            analyzer.init();
        }
    }

    @Override
    public boolean analyze(String ... record) {
        boolean result = true;
        this.results.resize(record.length);
        for (Analyzer<?> analyzer : this.analyzerArrays) {
            result &= analyzer.analyze(record);
        }
        return result;
    }

    @Override
    public void end() {
        for (Analyzer<?> executor : this.analyzerArrays) {
            executor.end();
        }
    }

    @Override
    public List<Result> getResult() {
        for (Analyzer<?> analyzer : this.analyzerArrays) {
            List<?> analysis = analyzer.getResult();
            if (analysis == null) continue;
            for (int j = 0; j < analysis.size(); ++j) {
                this.results.get(j).add(analysis.get(j));
            }
        }
        return this.results;
    }

    @Override
    public Analyzer<Result> merge(Analyzer<Result> another) {
        throw new NotImplementedException();
    }

    @Override
    public void close() throws Exception {
        for (Analyzer<?> analyzer : this.analyzerArrays) {
            try {
                analyzer.close();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Unable to close " + analyzer), (Throwable)e);
            }
        }
    }

    public static class Result {
        private final Map<Class<?>, Object> results = new HashMap();

        public <T> T get(Class<T> clazz) {
            if (this.results.containsKey(clazz)) {
                return clazz.cast(this.results.get(clazz));
            }
            throw new IllegalArgumentException("No result of type '" + clazz.getName() + "'.");
        }

        public <T> boolean exist(Class<T> clazz) {
            return this.results.containsKey(clazz);
        }

        public void add(Object result) {
            this.results.put(result.getClass(), result);
        }
    }
}

