/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.common.inference;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class ValueQualityStatistics
implements Serializable {
    private static final long serialVersionUID = -4839915401904443142L;
    private final Set<String> invalidValues = new HashSet<String>();
    private final Set<String> unknownValues = new HashSet<String>();
    private long validCount;
    private long emptyCount;
    private long invalidCount;
    private long unknownCount;

    public Set<String> getInvalidValues() {
        return this.invalidValues;
    }

    public Set<String> getUnknownValues() {
        return this.unknownValues;
    }

    public long getValidCount() {
        return this.validCount;
    }

    public long getEmptyCount() {
        return this.emptyCount;
    }

    public long getInvalidCount() {
        return this.invalidCount;
    }

    public long getUnknownCount() {
        return this.unknownCount;
    }

    public long getCount() {
        return this.validCount + this.emptyCount + this.invalidCount + this.unknownCount;
    }

    public void incrementValid() {
        ++this.validCount;
    }

    public void incrementEmpty() {
        ++this.emptyCount;
    }

    public void incrementInvalid() {
        ++this.invalidCount;
    }

    public void incrementUnknown() {
        ++this.unknownCount;
    }

    public void appendInvalidValue(String value) {
        this.invalidValues.add(value);
    }

    public void appendUnknownValue(String value) {
        this.unknownValues.add(value);
    }

    public void setValidCount(long newCount) {
        this.validCount = newCount;
    }

    public void setEmptyCount(long newCount) {
        this.emptyCount = newCount;
    }

    public void setInvalidCount(long newCount) {
        this.invalidCount = newCount;
    }

    public void setUnknownCount(long newCount) {
        this.unknownCount = newCount;
    }

    public String toString() {
        return "ValueQuality{valid=" + this.validCount + ", empty=" + this.emptyCount + ", invalid=" + this.invalidCount + '}' + ", unknown=" + this.unknownCount + '}' + "InvalidValues{" + this.invalidValues + "} UnknownValues{" + this.unknownValues + "}";
    }
}

