/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.converters;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DecimalStyle;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DateCalendarConverter {
    private static final Logger LOG = Logger.getLogger(DateCalendarConverter.class);
    public static final String DEFAULT_INPUT_PATTERN = "yyyy-MM-dd";
    public static final String DEFAULT_OUTPUT_PATTERN = "yyyy-MM-dd";
    public static final Locale DEFAULT_OUTPUT_LOCALE = Locale.getDefault();
    public static final Locale DEFAULT_INPUT_LOCALE = Locale.getDefault();
    protected String inputFormatPattern = "yyyy-MM-dd";
    protected String outputFormatPattern = "yyyy-MM-dd";
    protected Chronology inputChronologyType = IsoChronology.INSTANCE;
    protected Chronology outputChronologyType = IsoChronology.INSTANCE;
    protected DateTimeFormatter inputDateTimeFormatter;
    protected DateTimeFormatter outputDateTimeFormatter;

    public DateCalendarConverter() {
        this("yyyy-MM-dd", "yyyy-MM-dd", IsoChronology.INSTANCE, IsoChronology.INSTANCE, DEFAULT_INPUT_LOCALE, DEFAULT_OUTPUT_LOCALE);
    }

    public DateCalendarConverter(Chronology inputChronologyType, Chronology outputChronologyType) {
        this("yyyy-MM-dd", "yyyy-MM-dd", inputChronologyType, outputChronologyType, DEFAULT_INPUT_LOCALE, DEFAULT_OUTPUT_LOCALE);
    }

    public DateCalendarConverter(String inputFormatPattern, String outputFormatPattern) {
        this(inputFormatPattern, outputFormatPattern, null, null, DEFAULT_INPUT_LOCALE, DEFAULT_OUTPUT_LOCALE);
    }

    public DateCalendarConverter(String inputFormatPattern, String outputFormatPattern, Chronology inputChronologyType, Chronology outputChronologyType, Locale inputLocale, Locale outputLocale) {
        this(inputFormatPattern, outputFormatPattern, inputChronologyType, outputChronologyType);
        this.inputDateTimeFormatter = this.inputDateTimeFormatter.withLocale(inputLocale);
        this.outputDateTimeFormatter = this.outputDateTimeFormatter.withLocale(outputLocale);
    }

    public DateCalendarConverter(String inputFormatPattern, String outputFormatPattern, Chronology inputChronologyType, Chronology outputChronologyType) {
        this.inputChronologyType = inputChronologyType == null ? IsoChronology.INSTANCE : inputChronologyType;
        this.outputChronologyType = outputChronologyType == null ? IsoChronology.INSTANCE : outputChronologyType;
        this.inputFormatPattern = inputFormatPattern == null ? "yyyy-MM-dd" : inputFormatPattern;
        this.outputFormatPattern = outputFormatPattern == null ? "yyyy-MM-dd" : outputFormatPattern;
        this.inputDateTimeFormatter = new DateTimeFormatterBuilder().parseLenient().appendPattern(this.inputFormatPattern).toFormatter().withChronology(this.inputChronologyType).withDecimalStyle(DecimalStyle.of(Locale.getDefault(Locale.Category.FORMAT)));
        this.outputDateTimeFormatter = new DateTimeFormatterBuilder().parseLenient().appendPattern(this.outputFormatPattern).toFormatter().withChronology(this.outputChronologyType).withDecimalStyle(DecimalStyle.of(Locale.getDefault(Locale.Category.FORMAT)));
    }

    public String convert(String inputDateStr) {
        if (inputDateStr == null || "".equals(inputDateStr.trim())) {
            return inputDateStr;
        }
        if (this.inputChronologyType.equals(this.outputChronologyType) && this.inputFormatPattern.equals(this.outputFormatPattern)) {
            return inputDateStr;
        }
        LocalDate inputLocalDate = this.parseStringToDate(inputDateStr);
        return this.formatDateToString(inputLocalDate);
    }

    protected String formatDateToString(LocalDate inputLocalDate) {
        if (inputLocalDate != null) {
            ChronoLocalDate cDate;
            try {
                cDate = this.outputChronologyType.date(inputLocalDate);
            }
            catch (DateTimeException ex) {
                LOG.error((Object)ex, (Throwable)ex);
                cDate = inputLocalDate;
            }
            try {
                return this.outputDateTimeFormatter.format(cDate);
            }
            catch (DateTimeException ex) {
                LOG.error((Object)ex, (Throwable)ex);
                return "";
            }
        }
        return "";
    }

    protected LocalDate parseStringToDate(String inputDateStr) {
        try {
            TemporalAccessor temporal = this.inputDateTimeFormatter.parse(inputDateStr);
            ChronoLocalDate cDate = this.inputChronologyType.date(temporal);
            return LocalDate.from(cDate);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            return null;
        }
    }
}

