/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.converters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class DuplicateCharEraser {
    private Pattern removeRepeatCharPattern = null;

    public DuplicateCharEraser() {
        this.removeRepeatCharPattern = Pattern.compile("([\\s\\u0085\\p{Z}]|\r\n)\\1+");
    }

    public DuplicateCharEraser(char repeatChar) {
        this(Character.toString(repeatChar));
    }

    public DuplicateCharEraser(String repeatChar) {
        this.removeRepeatCharPattern = Pattern.compile("(" + Pattern.quote(repeatChar) + ")\\1+");
    }

    public String removeRepeatedChar(String inputStr) {
        if (StringUtils.isEmpty((String)inputStr)) {
            return inputStr;
        }
        Matcher matcher = this.removeRepeatCharPattern.matcher(inputStr);
        return matcher.replaceAll("$1");
    }
}

