/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.converters;

import java.math.BigDecimal;
import org.talend.dataquality.converters.DistanceEnum;

public class DistanceConverter {
    public static final DistanceEnum DEFAULT_DISTANCE_FROM = DistanceEnum.MILE;
    public static final DistanceEnum DEFAULT_DISTANCE_TO = DistanceEnum.KILOMETER;
    private DistanceEnum deFrom;
    private DistanceEnum deTo;
    private BigDecimal multiplier;

    public DistanceConverter() {
        this(DEFAULT_DISTANCE_FROM, DEFAULT_DISTANCE_TO);
    }

    public DistanceConverter(DistanceEnum from, DistanceEnum to) {
        this.deFrom = from == null ? DEFAULT_DISTANCE_FROM : from;
        this.deTo = to == null ? DEFAULT_DISTANCE_TO : to;
        this.multiplier = new BigDecimal(String.valueOf(this.deFrom.getConversionToBase())).multiply(new BigDecimal(String.valueOf(this.deTo.getConversionFromBase())));
    }

    public double convert(double value) {
        if (Double.isNaN(value)) {
            return value;
        }
        if (this.deFrom.equals((Object)this.deTo)) {
            return value;
        }
        BigDecimal bdResult = new BigDecimal(String.valueOf(value)).multiply(this.multiplier);
        return bdResult.doubleValue();
    }
}

