/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.converters;

public enum DistanceEnum {
    MILLIMETER("millimeter", "mm", 0.001, 1000.0),
    CENTIMETER("centimeter", "cm", 0.01, 100.0),
    DECIMETER("decimeter", "dm", 0.1, 10.0),
    METER("meter", "m", 1.0, 1.0),
    DEKAMETER("dekameter", "dam", 10.0, 0.1),
    HECTOMETER("hectometer", "hm", 100.0, 0.01),
    KILOMETER("kilometer", "km", 1000.0, 0.001),
    INCH("inch", "in", 0.0254, 39.37007874015748),
    FOOT("foot", "ft", 0.3048, 3.2808398950131235),
    YARD("yard", "yd", 0.9144, 1.0936132983377078),
    MILE("mile", "mi", 1609.344, 6.213711922373339E-4),
    NAUTICAL_MILE("nautical mile", "nm", 1852.0, 5.399568034557236E-4),
    LIGHT_YEAR("light-year", "ly", 9.4607304725808E15, 1.0570008340246154E-16);

    private String displayName;
    private String shortName;
    private double conversionToBase;
    private double conversionFromBase;

    private DistanceEnum(String displayName, String shortName, double conversionToBase, double conversionFromBase) {
        this.displayName = displayName;
        this.shortName = shortName;
        this.conversionToBase = conversionToBase;
        this.conversionFromBase = conversionFromBase;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public double getConversionToBase() {
        return this.conversionToBase;
    }

    public double getConversionFromBase() {
        return this.conversionFromBase;
    }

    public String toString() {
        return this.displayName;
    }
}

