/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.converters;

import java.time.temporal.ChronoUnit;

public class DurationConverter {
    private static final double num_24 = 24.0;
    private static final double num_60 = 60.0;
    private static final double num_1000 = 1000.0;
    private static final double num_365 = 365.0;
    private static final double num_30 = 30.0;
    private static final double num_7 = 7.0;
    private static final double num_52 = 52.0;
    private static final double num_12 = 12.0;
    public static final ChronoUnit DEFAULT_FROM_UNIT = ChronoUnit.DAYS;
    public static final ChronoUnit DEFAULT_TO_UNIT = ChronoUnit.HOURS;
    private ChronoUnit fromUnit;
    private ChronoUnit toUnit;

    public DurationConverter() {
        this(DEFAULT_FROM_UNIT, DEFAULT_TO_UNIT);
    }

    public DurationConverter(ChronoUnit from, ChronoUnit to) {
        this.fromUnit = from == null ? DEFAULT_FROM_UNIT : from;
        this.toUnit = to == null ? DEFAULT_TO_UNIT : to;
    }

    public double convert(double value) {
        if (Double.isNaN(value)) {
            return value;
        }
        if (Double.compare(Double.MAX_VALUE, value) == 0 || Double.compare(Double.MIN_VALUE, value) == 0) {
            return value;
        }
        if (this.fromUnit.equals(this.toUnit)) {
            return value;
        }
        double days = 0.0;
        switch (this.fromUnit) {
            case MILLIS: {
                days = value / 24.0 / 60.0 / 60.0 / 1000.0;
                break;
            }
            case SECONDS: {
                days = value / 24.0 / 60.0 / 60.0;
                break;
            }
            case MINUTES: {
                days = value / 24.0 / 60.0;
                break;
            }
            case HOURS: {
                days = value / 24.0;
                break;
            }
            case DAYS: {
                days = value;
                break;
            }
            case YEARS: {
                days = value * 365.0;
                break;
            }
            case MONTHS: {
                days = value * 30.0;
                break;
            }
            case WEEKS: {
                days = value * 7.0;
                break;
            }
        }
        switch (this.toUnit) {
            case MILLIS: {
                return this.getExactDays(value, days) * 24.0 * 60.0 * 60.0 * 1000.0;
            }
            case SECONDS: {
                return this.getExactDays(value, days) * 24.0 * 60.0 * 60.0;
            }
            case MINUTES: {
                return this.getExactDays(value, days) * 24.0 * 60.0;
            }
            case HOURS: {
                return this.getExactDays(value, days) * 24.0;
            }
            case DAYS: {
                return this.getExactDays(value, days);
            }
            case YEARS: {
                return days / 365.0;
            }
            case MONTHS: {
                return days / 30.0;
            }
            case WEEKS: {
                return days / 7.0;
            }
        }
        return value;
    }

    protected double getExactDays(double value, double days) {
        if (this.fromUnit == ChronoUnit.MONTHS) {
            int year = (int)(value / 12.0);
            int month = (int)(value % 12.0);
            return (double)year * 365.0 + (double)month * 30.0;
        }
        if (this.fromUnit == ChronoUnit.WEEKS) {
            int year = (int)(value / 52.0);
            int week = (int)(value % 52.0);
            return (double)year * 365.0 + (double)week * 7.0;
        }
        return days;
    }
}

