/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.converters;

import java.time.LocalDate;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DecimalStyle;
import java.time.temporal.TemporalField;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.talend.dataquality.converters.DateCalendarConverter;

public class JulianDayConverter
extends DateCalendarConverter {
    private boolean convertCalendarToTemporal = false;
    private TemporalField inputTemporalField = null;
    private TemporalField outputTemporalField = null;

    public JulianDayConverter(Chronology inputChronologyType, TemporalField outputTemporalField) {
        this(inputChronologyType, null, null, outputTemporalField);
    }

    public JulianDayConverter(Chronology inputChronologyType, String inputFormatPattern, Locale inputLocale, TemporalField outputTemporalField) {
        this.convertCalendarToTemporal = true;
        this.inputChronologyType = inputChronologyType;
        this.inputFormatPattern = inputFormatPattern != null ? inputFormatPattern : "yyyy-MM-dd";
        this.outputTemporalField = outputTemporalField;
        Locale locale = inputLocale != null ? inputLocale : Locale.getDefault(Locale.Category.FORMAT);
        this.inputDateTimeFormatter = new DateTimeFormatterBuilder().parseLenient().appendPattern(this.inputFormatPattern).toFormatter(locale).withChronology(this.inputChronologyType).withDecimalStyle(DecimalStyle.of(locale));
    }

    public JulianDayConverter(TemporalField inputTemporalField, Chronology outputChronologyType) {
        this(inputTemporalField, outputChronologyType, null, null);
    }

    public JulianDayConverter(TemporalField inputTemporalField, Chronology outputChronologyType, String outputFormatPattern, Locale outputLocale) {
        this.convertCalendarToTemporal = false;
        this.inputTemporalField = inputTemporalField;
        this.outputChronologyType = outputChronologyType;
        this.outputFormatPattern = outputFormatPattern != null ? outputFormatPattern : "yyyy-MM-dd G";
        Locale locale = outputLocale != null ? outputLocale : Locale.getDefault(Locale.Category.FORMAT);
        this.inputDateTimeFormatter = new DateTimeFormatterBuilder().parseLenient().appendValue(inputTemporalField).toFormatter().withDecimalStyle(DecimalStyle.of(locale));
        this.outputDateTimeFormatter = new DateTimeFormatterBuilder().parseLenient().appendPattern(this.outputFormatPattern).toFormatter(locale).withChronology(this.outputChronologyType).withDecimalStyle(DecimalStyle.of(locale));
    }

    public JulianDayConverter(TemporalField inputTemporalField, TemporalField outputTemporalField) {
        this.convertCalendarToTemporal = false;
        this.inputTemporalField = inputTemporalField;
        this.outputTemporalField = outputTemporalField;
        this.inputDateTimeFormatter = new DateTimeFormatterBuilder().parseLenient().appendValue(inputTemporalField).toFormatter().withDecimalStyle(DecimalStyle.of(Locale.getDefault(Locale.Category.FORMAT)));
    }

    @Override
    public String convert(String inputDateStr) {
        if (StringUtils.isEmpty((String)inputDateStr)) {
            return inputDateStr;
        }
        String outputDateStr = inputDateStr;
        LocalDate localDate = super.parseStringToDate(inputDateStr);
        if (localDate == null) {
            return outputDateStr;
        }
        outputDateStr = this.convertCalendarToTemporal ? Long.toString(localDate.getLong(this.outputTemporalField)) : (this.inputTemporalField != null && this.outputTemporalField != null ? Long.toString(localDate.getLong(this.outputTemporalField)) : this.formatDateToString(localDate));
        return outputDateStr;
    }
}

