/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.converters;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class StringTrimmer {
    public static final Set<Character> WHITESPACE_CHARS_SUPERIOR_ASCII_SPACE = new HashSet<Character>(Arrays.asList(Character.valueOf('\u0085'), Character.valueOf('\u00a0'), Character.valueOf('\u1680'), Character.valueOf('\u180e'), Character.valueOf('\u2000'), Character.valueOf('\u2001'), Character.valueOf('\u2002'), Character.valueOf('\u2003'), Character.valueOf('\u2004'), Character.valueOf('\u2005'), Character.valueOf('\u2006'), Character.valueOf('\u2007'), Character.valueOf('\u2008'), Character.valueOf('\u2009'), Character.valueOf('\u200a'), Character.valueOf('\u2028'), Character.valueOf('\u2029'), Character.valueOf('\u202f'), Character.valueOf('\u205f'), Character.valueOf('\u3000')));

    public String removeTrailingAndLeadingWhitespaces(String inputStr) {
        if (StringUtils.isEmpty((String)inputStr)) {
            return inputStr;
        }
        int startIndex = 0;
        int endIndex = inputStr.length();
        char currentCharacter = inputStr.charAt(startIndex);
        while (startIndex < endIndex && (currentCharacter <= ' ' || WHITESPACE_CHARS_SUPERIOR_ASCII_SPACE.contains(Character.valueOf(currentCharacter)))) {
            currentCharacter = inputStr.charAt(++startIndex);
        }
        if (startIndex == endIndex) {
            return "";
        }
        while ((currentCharacter = inputStr.charAt(--endIndex)) <= ' ' || WHITESPACE_CHARS_SUPERIOR_ASCII_SPACE.contains(Character.valueOf(currentCharacter))) {
        }
        return inputStr.substring(startIndex, endIndex + 1);
    }

    public String removeTrailingAndLeading(String inputStr) {
        return this.removeTrailingAndLeading(inputStr, " ");
    }

    public String removeTrailingAndLeading(String inputStr, String removeStr) {
        if (StringUtils.isEmpty((String)inputStr) || StringUtils.isEmpty((String)removeStr)) {
            return inputStr;
        }
        if (removeStr.length() == 1) {
            return this.removeTrailingAndLeading(inputStr, Character.valueOf(removeStr.charAt(0)));
        }
        String result = inputStr;
        while (result.startsWith(removeStr)) {
            result = StringUtils.removeStart((String)result, (String)removeStr);
        }
        while (result.endsWith(removeStr)) {
            result = StringUtils.removeEnd((String)result, (String)removeStr);
        }
        return result;
    }

    public String removeTrailingAndLeading(String inputStr, Character removeCharacter) {
        if (StringUtils.isEmpty((String)inputStr)) {
            return inputStr;
        }
        int startIndex = 0;
        int endIndex = inputStr.length();
        char currentCharacter = inputStr.charAt(startIndex);
        while (startIndex < endIndex && currentCharacter == removeCharacter.charValue()) {
            currentCharacter = inputStr.charAt(++startIndex);
        }
        if (startIndex == endIndex) {
            return "";
        }
        while ((currentCharacter = inputStr.charAt(--endIndex)) == removeCharacter.charValue()) {
        }
        return inputStr.substring(startIndex, endIndex + 1);
    }
}

