/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.talend.dataquality.semantic.api.CategoryRegistryManager;
import org.talend.dataquality.semantic.api.DictionaryUtils;
import org.talend.dataquality.semantic.api.LocalDictionaryCache;
import org.talend.dataquality.semantic.api.internal.CustomDocumentIndexAccess;
import org.talend.dataquality.semantic.api.internal.CustomMetadataIndexAccess;
import org.talend.dataquality.semantic.api.internal.CustomRegexClassifierAccess;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedCategory;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedClassifier;
import org.talend.dataquality.semantic.model.CategoryType;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.model.DQDocument;

public class CustomDictionaryHolder {
    private static final Logger LOGGER = Logger.getLogger(CustomDictionaryHolder.class);
    private static final String TALEND = "Talend";
    private static final String INITIALIZE_ACCESS = "Initialize %s %s access for [%s]";
    private static final String CUSTOM = "custom";
    private Map<String, DQCategory> metadata;
    private Directory dataDictDirectory;
    private UserDefinedClassifier regexClassifier;
    private CustomMetadataIndexAccess customMetadataIndexAccess;
    private CustomDocumentIndexAccess customDataDictIndexAccess;
    private CustomRegexClassifierAccess customRegexClassifierAccess;
    private CustomMetadataIndexAccess customRepublishMetadataIndexAccess;
    private CustomDocumentIndexAccess customRepublishDataDictIndexAccess;
    private CustomRegexClassifierAccess customRepublishRegexClassifierAccess;
    private LocalDictionaryCache localDictionaryCache;
    private String tenantID;

    public CustomDictionaryHolder(String tenantID) {
        this.tenantID = tenantID;
        if (CategoryRegistryManager.isUsingLocalCategoryRegistry()) {
            this.checkCustomFolders();
        }
    }

    private void checkCustomFolders() {
        File metadataFolder = new File(this.getIndexFolderPath(true, "metadata"));
        if (metadataFolder.exists()) {
            this.ensureMetadataIndexAccess();
            File dataDictFolder = new File(this.getIndexFolderPath(true, "dictionary"));
            if (dataDictFolder.exists()) {
                this.ensureDataDictIndexAccess();
            }
            this.ensureRegexClassifierAccess();
        }
    }

    public String getTenantID() {
        return this.tenantID;
    }

    private String getIndexFolderPath(boolean isProduction, String indexName) {
        return CategoryRegistryManager.getLocalRegistryPath() + File.separator + this.tenantID + File.separator + (isProduction ? "prod" : "republish") + File.separator + indexName;
    }

    public Map<String, DQCategory> getMetadata() {
        if (this.metadata == null) {
            this.metadata = CategoryRegistryManager.getInstance().getSharedCategoryMetadata();
        }
        return this.metadata;
    }

    public Directory getDataDictDirectory() {
        if (this.dataDictDirectory == null) {
            this.ensureDataDictIndexAccess();
        }
        return this.dataDictDirectory;
    }

    public UserDefinedClassifier getRegexClassifier() throws IOException {
        if (this.regexClassifier == null) {
            return CategoryRegistryManager.getInstance().getRegexClassifier(false);
        }
        return this.regexClassifier;
    }

    private synchronized void ensureMetadataIndexAccess() {
        if (this.customMetadataIndexAccess == null) {
            LOGGER.info((Object)String.format(INITIALIZE_ACCESS, CUSTOM, "metadata", this.tenantID));
            String metadataIndexPath = this.getIndexFolderPath(true, "metadata");
            File folder = new File(metadataIndexPath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            try {
                this.customMetadataIndexAccess = new CustomMetadataIndexAccess((Directory)FSDirectory.open((File)folder));
                this.metadata = this.customMetadataIndexAccess.readCategoryMedatada();
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private synchronized void ensureDataDictIndexAccess() {
        this.ensureMetadataIndexAccess();
        if (this.customDataDictIndexAccess == null) {
            LOGGER.info((Object)String.format(INITIALIZE_ACCESS, CUSTOM, "dictionary", this.tenantID));
            String dataDictIndexPath = this.getIndexFolderPath(true, "dictionary");
            File folder = new File(dataDictIndexPath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            try {
                this.dataDictDirectory = FSDirectory.open((File)folder);
                this.customDataDictIndexAccess = new CustomDocumentIndexAccess(this.dataDictDirectory);
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private synchronized void ensureRepublishDataDictIndexAccess() {
        if (this.customRepublishDataDictIndexAccess == null) {
            LOGGER.info((Object)(String.format(INITIALIZE_ACCESS, "republish", "dictionary", this.tenantID) + this.tenantID));
            String dataDictIndexPath = this.getIndexFolderPath(false, "dictionary");
            File folder = new File(dataDictIndexPath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            try {
                this.customRepublishDataDictIndexAccess = new CustomDocumentIndexAccess((Directory)FSDirectory.open((File)folder));
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private synchronized void ensureRepublishMetadataIndexAccess() {
        if (this.customRepublishMetadataIndexAccess == null) {
            LOGGER.info((Object)String.format(INITIALIZE_ACCESS, "republish", "metadata", this.tenantID));
            String dataDictIndexPath = this.getIndexFolderPath(false, "metadata");
            File folder = new File(dataDictIndexPath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            try {
                this.customRepublishMetadataIndexAccess = new CustomMetadataIndexAccess((Directory)FSDirectory.open((File)folder));
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void createCategory(DQCategory category) {
        if (CategoryType.REGEX.equals((Object)category.getType())) {
            this.insertOrUpdateRegexCategory(category);
        }
        category.setModified(Boolean.valueOf(true));
        this.ensureMetadataIndexAccess();
        this.customMetadataIndexAccess.createCategory(category);
        this.customMetadataIndexAccess.commitChanges();
        this.metadata = this.customMetadataIndexAccess.readCategoryMedatada();
    }

    public void updateCategory(DQCategory category) {
        if (CategoryType.DICT.equals((Object)category.getType())) {
            this.copyDataDictByCategoryFromSharedDirectory(category.getId());
        } else if (CategoryType.REGEX.equals((Object)category.getType())) {
            this.insertOrUpdateRegexCategory(category);
        }
        category.setModified(Boolean.valueOf(true));
        this.ensureMetadataIndexAccess();
        this.customMetadataIndexAccess.insertOrUpdateCategory(category);
        this.customMetadataIndexAccess.commitChanges();
        this.metadata = this.customMetadataIndexAccess.readCategoryMedatada();
    }

    private void copyDataDictByCategoryFromSharedDirectory(String categoryId) {
        DQCategory dqCat = this.getMetadata().get(categoryId);
        if (dqCat != null && !Boolean.TRUE.equals(dqCat.getModified()) && !Boolean.TRUE.equals(dqCat.getDeleted())) {
            this.ensureDataDictIndexAccess();
            this.customDataDictIndexAccess.copyBaseDocumentsFromSharedDirectory(dqCat);
        }
    }

    public void deleteCategory(DQCategory category) {
        category.setDeleted(Boolean.valueOf(true));
        this.ensureMetadataIndexAccess();
        String categoryId = category.getId();
        if (TALEND.equals(category.getCreator())) {
            this.customMetadataIndexAccess.insertOrUpdateCategory(category);
            if (CategoryType.REGEX.equals((Object)category.getType())) {
                this.customRegexClassifierAccess.deleteRegex(DictionaryUtils.regexClassifierfromDQCategory(category));
            } else if (Boolean.TRUE.equals(category.getModified())) {
                LOGGER.debug((Object)("deleteDocumentsByCategoryId " + categoryId));
                this.ensureDataDictIndexAccess();
                this.customDataDictIndexAccess.deleteDocumentsByCategoryId(categoryId);
            }
        } else {
            if (CategoryType.REGEX.equals((Object)category.getType())) {
                this.customRegexClassifierAccess.deleteRegex(DictionaryUtils.regexClassifierfromDQCategory(category));
            }
            this.customMetadataIndexAccess.deleteCategory(category);
            LOGGER.debug((Object)("deleteDocumentsByCategoryId " + categoryId));
            this.ensureDataDictIndexAccess();
            this.customDataDictIndexAccess.deleteDocumentsByCategoryId(categoryId);
        }
        this.customMetadataIndexAccess.commitChanges();
        this.metadata = this.customMetadataIndexAccess.readCategoryMedatada();
    }

    public void reloadCategoryMetadata() {
        this.checkCustomFolders();
        if (this.customMetadataIndexAccess != null) {
            this.metadata = this.customMetadataIndexAccess.readCategoryMedatada();
        }
        if (this.customRegexClassifierAccess != null) {
            this.regexClassifier = this.customRegexClassifierAccess.readUserDefinedClassifier();
        }
    }

    public void updateDataDictDocuments(List<DQDocument> documents) {
        this.ensureDataDictIndexAccess();
        this.operationDataDictDocuments(documents, this.customDataDictIndexAccess::insertOrUpdateDocument);
    }

    public void addDataDictDocuments(List<DQDocument> documents) {
        this.ensureDataDictIndexAccess();
        this.operationDataDictDocuments(documents, this.customDataDictIndexAccess::createDocument);
    }

    public void deleteDataDictDocuments(List<DQDocument> documents) {
        this.ensureDataDictIndexAccess();
        this.operationDataDictDocuments(documents, this.customDataDictIndexAccess::deleteDocument);
    }

    private void operationDataDictDocuments(List<DQDocument> documents, Consumer<List<DQDocument>> function) {
        String categoryId = documents.get(0).getCategory().getId();
        DQCategory category = this.getMetadata().get(categoryId);
        if (category != null && !Boolean.TRUE.equals(category.getModified()) && !Boolean.TRUE.equals(category.getDeleted())) {
            this.updateCategory(category);
        }
        function.accept(documents);
        this.customDataDictIndexAccess.commitChanges();
    }

    void closeDictionaryAccess() {
        try {
            if (this.customMetadataIndexAccess != null) {
                this.customMetadataIndexAccess.close();
            }
            if (this.customDataDictIndexAccess != null) {
                this.customDataDictIndexAccess.close();
            }
            this.closeDictionaryCache();
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.customMetadataIndexAccess = null;
            this.customDataDictIndexAccess = null;
            this.customRegexClassifierAccess = null;
        }
    }

    void closeRepublishDictionaryAccess() {
        try {
            if (this.customRepublishMetadataIndexAccess != null) {
                this.customRepublishMetadataIndexAccess.close();
            }
            if (this.customRepublishDataDictIndexAccess != null) {
                this.customRepublishDataDictIndexAccess.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.customRepublishMetadataIndexAccess = null;
            this.customRepublishDataDictIndexAccess = null;
            this.customRepublishRegexClassifierAccess = null;
        }
    }

    private synchronized void ensureRegexClassifierAccess() {
        if (this.customRegexClassifierAccess == null) {
            LOGGER.info((Object)String.format(INITIALIZE_ACCESS, CUSTOM, "regex", this.tenantID));
            this.customRegexClassifierAccess = new CustomRegexClassifierAccess(this);
            this.regexClassifier = this.customRegexClassifierAccess.readUserDefinedClassifier();
        }
    }

    private synchronized void ensureRepublishRegexClassifierAccess() {
        if (this.customRepublishRegexClassifierAccess == null) {
            LOGGER.info((Object)String.format(INITIALIZE_ACCESS, "republish", "regex", this.tenantID));
            this.customRepublishRegexClassifierAccess = new CustomRegexClassifierAccess(this.getIndexFolderPath(false, "regex" + File.separator + "categorizer.json"));
        }
    }

    public void insertOrUpdateRegexCategory(DQCategory category) {
        this.ensureRegexClassifierAccess();
        UserDefinedCategory regEx = DictionaryUtils.regexClassifierfromDQCategory(category);
        this.customRegexClassifierAccess.insertOrUpdateRegex(regEx);
        this.regexClassifier = this.customRegexClassifierAccess.readUserDefinedClassifier();
    }

    public LocalDictionaryCache getDictionaryCache() {
        if (this.localDictionaryCache == null) {
            this.localDictionaryCache = new LocalDictionaryCache(this);
        }
        return this.localDictionaryCache;
    }

    public void closeDictionaryCache() {
        if (this.localDictionaryCache != null) {
            this.localDictionaryCache.close();
            this.localDictionaryCache = null;
        }
    }

    public Collection<DQCategory> listCategories() {
        return this.getMetadata().values();
    }

    public Collection<DQCategory> listCategories(boolean includeOpenCategories) {
        if (includeOpenCategories) {
            return this.getMetadata().values();
        }
        ArrayList<DQCategory> catList = new ArrayList<DQCategory>();
        for (DQCategory dqCat : this.getMetadata().values()) {
            if (!dqCat.getCompleteness().booleanValue()) continue;
            catList.add(dqCat);
        }
        return catList;
    }

    public List<DQCategory> listCategories(CategoryType type) {
        ArrayList<DQCategory> catList = new ArrayList<DQCategory>();
        for (DQCategory dqCat : this.getMetadata().values()) {
            if (!type.equals((Object)dqCat.getType())) continue;
            catList.add(dqCat);
        }
        return catList;
    }

    public DQCategory getCategoryMetadataById(String catId) {
        return this.getMetadata().get(catId);
    }

    public DQCategory getCategoryMetadataByName(String catName) {
        for (DQCategory cat : this.getMetadata().values()) {
            if (!cat.getName().equals(catName)) continue;
            return cat;
        }
        return null;
    }

    public IndexWriter getMetadataIndexWriter() throws IOException {
        this.ensureMetadataIndexAccess();
        return this.customMetadataIndexAccess.getWriter();
    }

    public IndexWriter getDataDictIndexWriter() throws IOException {
        this.ensureDataDictIndexAccess();
        return this.customDataDictIndexAccess.getWriter();
    }

    public void beforeRepublish() {
        LOGGER.debug((Object)"Prepare publication folder");
        this.ensureRepublishMetadataIndexAccess();
        for (DQCategory category : CategoryRegistryManager.getInstance().getSharedCategoryMetadata().values()) {
            category.setDeleted(Boolean.valueOf(true));
            this.customRepublishMetadataIndexAccess.insertOrUpdateCategory(category);
        }
    }

    public void republishDataDictDocuments(List<DQDocument> documents) {
        this.ensureRepublishDataDictIndexAccess();
        this.customRepublishDataDictIndexAccess.createDocument(documents);
    }

    public void republishCategory(DQCategory category) {
        this.ensureRepublishMetadataIndexAccess();
        category.setModified(Boolean.valueOf(true));
        if (CategoryRegistryManager.getInstance().getSharedCategoryMetadata().containsKey(category.getId())) {
            if (category.getLastModifier() == null || TALEND.equals(category.getLastModifier())) {
                category.setModified(Boolean.valueOf(false));
            }
            this.customRepublishMetadataIndexAccess.insertOrUpdateCategory(category);
        } else {
            this.customRepublishMetadataIndexAccess.createCategory(category);
        }
        if (CategoryType.REGEX.equals((Object)category.getType())) {
            this.republishRegexCategory(category);
        }
        this.customRepublishMetadataIndexAccess.commitChanges();
    }

    public void republishRegexCategory(DQCategory category) {
        this.ensureRepublishRegexClassifierAccess();
        UserDefinedCategory regEx = DictionaryUtils.regexClassifierfromDQCategory(category);
        this.customRepublishRegexClassifierAccess.insertOrUpdateRegex(regEx);
    }

    public synchronized void publishDirectory() throws IOException {
        File productionIndexes;
        File backup;
        this.closeRepublishDictionaryAccess();
        File stagingIndexes = new File(CategoryRegistryManager.getLocalRegistryPath() + File.separator + this.tenantID + File.separator + "republish");
        if (stagingIndexes.exists() && !(backup = new File((productionIndexes = new File(CategoryRegistryManager.getLocalRegistryPath() + File.separator + this.tenantID + File.separator + "prod")).getPath() + ".old")).exists()) {
            File regexFile;
            File dictionaryFolder;
            if (productionIndexes.exists()) {
                LOGGER.info((Object)"[Post Republish] backup prod");
                FileUtils.copyDirectory((File)productionIndexes, (File)backup);
            }
            LOGGER.info((Object)"[Post Republish] insert staging directory into prod");
            File metadataFolder = new File(stagingIndexes.getAbsolutePath() + File.separator + "metadata");
            if (metadataFolder.exists()) {
                this.ensureMetadataIndexAccess();
                this.customMetadataIndexAccess.copyStagingContent(metadataFolder.getAbsolutePath());
            }
            if ((dictionaryFolder = new File(stagingIndexes.getAbsolutePath() + File.separator + "dictionary")).exists()) {
                this.ensureDataDictIndexAccess();
                this.customDataDictIndexAccess.copyStagingContent(dictionaryFolder.getAbsolutePath());
            }
            if ((regexFile = new File(stagingIndexes.getAbsolutePath() + File.separator + "regex" + File.separator + "categorizer.json")).exists()) {
                this.ensureRegexClassifierAccess();
                this.customRegexClassifierAccess.copyStagingContent(regexFile.getAbsolutePath());
            }
            LOGGER.info((Object)"[Post Republish] delete backup");
            FileUtils.deleteDirectory((File)backup);
            LOGGER.info((Object)"[Post Republish] delete staging contents");
            FileUtils.deleteDirectory((File)stagingIndexes);
        }
        this.reloadCategoryMetadata();
    }
}

