/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.api;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.talend.dataquality.semantic.api.CategoryRegistryManager;
import org.talend.dataquality.semantic.api.CustomDictionaryHolder;
import org.talend.dataquality.semantic.api.DictionaryUtils;
import org.talend.dataquality.semantic.index.ClassPathDirectory;
import org.talend.dataquality.semantic.index.DictionarySearcher;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.model.DQDocument;

public class LocalDictionaryCache {
    private static final Logger LOGGER = Logger.getLogger(LocalDictionaryCache.class);
    private SearcherManager sharedSearcherManager;
    private SearcherManager customSearcherMananger;
    private CustomDictionaryHolder customDictionaryHolder;

    LocalDictionaryCache(CustomDictionaryHolder customDictionaryHolder) {
        this.customDictionaryHolder = customDictionaryHolder;
        try {
            URI ddPath = CategoryRegistryManager.getInstance().getDictionaryURI();
            Directory sharedDir = ClassPathDirectory.open(ddPath);
            this.sharedSearcherManager = new SearcherManager(sharedDir, null);
            this.initCustomDirectory();
        }
        catch (IOException e) {
            LOGGER.error((Object)"Failed to read local dictionary cache! ", (Throwable)e);
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"Failed to parse index URI! ", (Throwable)e);
        }
    }

    private void initCustomDirectory() {
        try {
            Directory customDir = this.customDictionaryHolder.getDataDictDirectory();
            if (customDir != null) {
                this.customSearcherMananger = new SearcherManager(customDir, null);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Failed to read local dictionary cache! ", (Throwable)e);
        }
    }

    private List<DQDocument> dqDocListFromTopDocs(String catId, String catName, TopDocs docs) throws IOException {
        this.sharedSearcherManager.maybeRefresh();
        IndexSearcher searcher = (IndexSearcher)this.sharedSearcherManager.acquire();
        IndexReader reader = searcher.getIndexReader();
        ArrayList<DQDocument> dqDocList = new ArrayList<DQDocument>();
        for (ScoreDoc scoreDoc : docs.scoreDocs) {
            Document luceneDoc = reader.document(scoreDoc.doc);
            DQDocument dqDoc = DictionaryUtils.dictionaryEntryFromDocument(luceneDoc, catId, catName);
            dqDocList.add(dqDoc);
        }
        this.sharedSearcherManager.release((Object)searcher);
        return dqDocList;
    }

    public List<DQDocument> listDocuments(String categoryName, int offset, int n) {
        try {
            DQCategory dqCat = this.customDictionaryHolder.getCategoryMetadataByName(categoryName);
            TopDocs docs = this.sendListDocumentsQuery(dqCat.getId(), offset, n);
            return this.dqDocListFromTopDocs(dqCat.getId(), dqCat.getName(), docs);
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private Query getListDocumentsQuery(String categoryId) throws IOException {
        return new TermQuery(new Term("catid", categoryId));
    }

    private TopDocs sendListDocumentsQuery(String categoryId, int offset, int n) throws IOException {
        TopDocs result;
        this.sharedSearcherManager.maybeRefresh();
        IndexSearcher searcher = (IndexSearcher)this.sharedSearcherManager.acquire();
        if (offset <= 0) {
            result = searcher.search(this.getListDocumentsQuery(categoryId), n);
        } else {
            TopDocs topDocs = searcher.search(this.getListDocumentsQuery(categoryId), offset + n);
            TermQuery q = new TermQuery(new Term("catid", categoryId));
            result = searcher.searchAfter(topDocs.scoreDocs[Math.min(topDocs.totalHits, offset) - 1], (Query)q, n);
        }
        this.sharedSearcherManager.release((Object)searcher);
        return result;
    }

    public Set<String> suggestValues(String categoryName, String input) {
        return this.suggestValues(categoryName, input, 100);
    }

    public Set<String> suggestValues(String categoryName, String input, int num) {
        DQCategory dqCat;
        String trimmedInput;
        this.customDictionaryHolder.reloadCategoryMetadata();
        if (input != null && (trimmedInput = input.trim()).length() >= 2 && (dqCat = this.customDictionaryHolder.getCategoryMetadataByName(categoryName)) != null) {
            boolean isCategoryModified = dqCat.getModified();
            Set<String> values = this.doSuggestValues(categoryName, trimmedInput, num, true, isCategoryModified);
            if (values.isEmpty()) {
                return this.doSuggestValues(categoryName, trimmedInput, num, false, isCategoryModified);
            }
            return values;
        }
        return Collections.emptySet();
    }

    private Set<String> doSuggestValues(String categoryName, String input, int num, boolean isPrefixSearch, boolean searchCustomIndex) {
        String jointInput = DictionarySearcher.getJointTokens(input);
        String queryString = isPrefixSearch ? jointInput + "*" : "*" + jointInput + "*";
        BooleanQuery booleanQuery = new BooleanQuery();
        TermQuery catQuery = new TermQuery(new Term("word", categoryName));
        booleanQuery.add((Query)catQuery, BooleanClause.Occur.MUST);
        WildcardQuery wildcardQuery = new WildcardQuery(new Term("synterm", queryString));
        booleanQuery.add((Query)wildcardQuery, BooleanClause.Occur.MUST);
        TreeSet<String> results = new TreeSet<String>();
        try {
            SearcherManager searcherManager = this.getSearcherManager(searchCustomIndex);
            if (searcherManager != null) {
                searcherManager.maybeRefresh();
                IndexSearcher searcher = (IndexSearcher)searcherManager.acquire();
                TopDocs topDocs = searcher.search((Query)booleanQuery, num);
                for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
                    IndexableField[] fields;
                    Document doc = searcher.doc(topDocs.scoreDocs[i].doc);
                    for (IndexableField f : fields = doc.getFields("raw")) {
                        String str = f.stringValue();
                        if (isPrefixSearch) {
                            if (!StringUtils.startsWithIgnoreCase((CharSequence)str, (CharSequence)input) && !StringUtils.startsWithIgnoreCase((CharSequence)DictionarySearcher.getJointTokens(str), (CharSequence)jointInput)) continue;
                            results.add(str);
                            continue;
                        }
                        if (!StringUtils.containsIgnoreCase((CharSequence)str, (CharSequence)input) && !StringUtils.containsIgnoreCase((CharSequence)DictionarySearcher.getJointTokens(str), (CharSequence)jointInput)) continue;
                        results.add(str);
                    }
                }
                searcherManager.release((Object)searcher);
            }
        }
        catch (IOException e) {
            LOGGER.trace((Object)e.getMessage(), (Throwable)e);
        }
        return results;
    }

    private SearcherManager getSearcherManager(boolean searchCustomIndex) {
        if (searchCustomIndex) {
            if (this.customSearcherMananger == null) {
                this.initCustomDirectory();
            }
            return this.customSearcherMananger;
        }
        return this.sharedSearcherManager;
    }

    public void close() {
        if (this.sharedSearcherManager != null) {
            try {
                this.sharedSearcherManager.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (this.customSearcherMananger != null) {
            try {
                this.customSearcherMananger.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

