/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.api.internal;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.talend.dataquality.semantic.api.CategoryRegistryManager;
import org.talend.dataquality.semantic.api.CustomDictionaryHolder;
import org.talend.dataquality.semantic.classifier.ISubCategory;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedCategory;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedClassifier;

public class CustomRegexClassifierAccess {
    private static final Logger LOGGER = Logger.getLogger(CustomRegexClassifierAccess.class);
    private ObjectMapper mapper = new ObjectMapper();
    private File regExFile;

    public CustomRegexClassifierAccess(CustomDictionaryHolder holder) {
        String regexFilePath = CategoryRegistryManager.getLocalRegistryPath() + File.separator + holder.getTenantID() + File.separator + "prod" + File.separator + "regex" + File.separator + "categorizer.json";
        this.regExFile = new File(regexFilePath);
        if (!this.regExFile.exists()) {
            try {
                this.writeRegExs(new ArrayList<ISubCategory>(holder.getRegexClassifier().getClassifiers()));
            }
            catch (IOException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public CustomRegexClassifierAccess(String regexFilePath) {
        this.regExFile = new File(regexFilePath);
        if (!this.regExFile.exists()) {
            this.writeRegExs(new ArrayList<ISubCategory>());
        }
    }

    public void insertOrUpdateRegex(ISubCategory regEx) {
        LOGGER.debug((Object)("insertOrUpdateRegex: " + regEx));
        List<ISubCategory> regExs = this.getRegExs();
        if (regExs == null) {
            regExs = new ArrayList<ISubCategory>();
        } else {
            regExs.removeIf(expression -> expression.getId().equals(regEx.getId()));
        }
        regExs.add(regEx);
        this.writeRegExs(regExs);
    }

    public void deleteRegex(ISubCategory regEx) {
        LOGGER.debug((Object)("insertOrUpdateRegex: " + regEx));
        List<ISubCategory> regExs = this.getRegExs();
        if (regExs == null) {
            regExs = new ArrayList<ISubCategory>();
        } else {
            regExs.removeIf(expression -> regEx.getId().equals(expression.getId()));
        }
        this.writeRegExs(regExs);
    }

    private void writeRegExs(List<ISubCategory> regExs) {
        if (!this.regExFile.exists()) {
            this.regExFile.getParentFile().mkdirs();
        }
        try {
            this.mapper.writerWithDefaultPrettyPrinter().writeValue(this.regExFile, regExs);
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public List<ISubCategory> getRegExs() {
        List regExs = null;
        try {
            regExs = (List)this.mapper.readValue(this.regExFile, (TypeReference)new TypeReference<List<UserDefinedCategory>>(){});
        }
        catch (JsonMappingException jsonE) {
            if (!jsonE.getMessage().contains("No content")) {
                LOGGER.error((Object)jsonE.getMessage(), (Throwable)jsonE);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return regExs;
    }

    public UserDefinedClassifier readUserDefinedClassifier() {
        UserDefinedClassifier udc = new UserDefinedClassifier();
        List<ISubCategory> regExs = this.getRegExs();
        for (ISubCategory cat : regExs) {
            udc.addSubCategory(cat);
        }
        return udc;
    }

    public void copyStagingContent(String srcPath) throws IOException {
        FileUtils.copyFile((File)new File(srcPath), (File)this.regExFile);
    }
}

