/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.broadcast;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.talend.dataquality.semantic.api.CategoryRegistryManager;
import org.talend.dataquality.semantic.broadcast.BroadcastDocumentObject;
import org.talend.dataquality.semantic.broadcast.BroadcastUtils;
import org.talend.dataquality.semantic.model.CategoryType;
import org.talend.dataquality.semantic.model.DQCategory;

public class BroadcastIndexObject
implements Serializable {
    private static final long serialVersionUID = 7350930198992853600L;
    private static final Logger LOGGER = Logger.getLogger(BroadcastIndexObject.class);
    private List<BroadcastDocumentObject> documentList;
    private RAMDirectory ramDirectory;

    public BroadcastIndexObject() {
    }

    public BroadcastIndexObject(List<BroadcastDocumentObject> documentList) {
        this.documentList = documentList;
    }

    public BroadcastIndexObject(Directory inputDirectory) {
        this(inputDirectory, false);
    }

    public BroadcastIndexObject(Directory inputDirectory, Set<String> categories) {
        try {
            this.documentList = BroadcastUtils.readDocumentsFromIndex(inputDirectory, categories);
        }
        catch (IOException e) {
            this.documentList = Collections.emptyList();
            LOGGER.error((Object)"Unable to read synonym index.", (Throwable)e);
        }
    }

    public BroadcastIndexObject(Directory inputDirectory, boolean includeOpenCategories) {
        try {
            if (includeOpenCategories) {
                this.documentList = BroadcastUtils.readDocumentsFromIndex(inputDirectory);
            } else {
                Collection<DQCategory> cats = CategoryRegistryManager.getInstance().listCategories(false);
                HashSet<String> catIds = new HashSet<String>();
                for (DQCategory dqCat : cats) {
                    if (!CategoryType.DICT.equals((Object)dqCat.getType())) continue;
                    catIds.add(dqCat.getId());
                }
                this.documentList = BroadcastUtils.readDocumentsFromIndex(inputDirectory, catIds);
            }
        }
        catch (IOException e) {
            this.documentList = Collections.emptyList();
            LOGGER.error((Object)"Unable to read synonym index.", (Throwable)e);
        }
    }

    public List<BroadcastDocumentObject> getDocumentList() {
        return this.documentList;
    }

    public void setDocumentList(List<BroadcastDocumentObject> documentList) {
        this.documentList = documentList;
    }

    public synchronized Directory asDirectory() {
        if (this.ramDirectory == null) {
            try {
                this.ramDirectory = BroadcastUtils.createRamDirectoryFromDocuments(this.documentList);
            }
            catch (IOException e) {
                LOGGER.error((Object)"Unable to rebuild the broadcast dictionary.", (Throwable)e);
            }
        }
        return this.ramDirectory;
    }
}

