/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.broadcast;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Set;
import org.apache.log4j.Logger;
import org.talend.dataquality.semantic.classifier.ISubCategory;
import org.talend.dataquality.semantic.classifier.custom.UDCategorySerDeser;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedClassifier;

public class BroadcastRegexObject
implements Serializable {
    private static final long serialVersionUID = -7692833458780761739L;
    private static final Logger LOGGER = Logger.getLogger(BroadcastRegexObject.class);
    private UserDefinedClassifier regexClassifier;

    public BroadcastRegexObject() {
    }

    public BroadcastRegexObject(UserDefinedClassifier regexClassifier) {
        this.regexClassifier = regexClassifier;
    }

    public BroadcastRegexObject(UserDefinedClassifier udc, Set<String> categories) {
        this.regexClassifier = new UserDefinedClassifier();
        for (ISubCategory c : udc.getClassifiers()) {
            if (!categories.contains(c.getId())) continue;
            this.regexClassifier.addSubCategory(c);
        }
    }

    public BroadcastRegexObject(URI regexPath) {
        try {
            this.regexClassifier = UDCategorySerDeser.readJsonFile(regexPath);
        }
        catch (IOException e) {
            LOGGER.error((Object)("Failed to load resource from " + regexPath), (Throwable)e);
        }
    }

    public UserDefinedClassifier getRegexClassifier() {
        return this.regexClassifier;
    }

    public void setRegexClassifier(UserDefinedClassifier regexClassifier) {
        this.regexClassifier = regexClassifier;
    }
}

