/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.broadcast;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.Version;
import org.talend.dataquality.semantic.api.DictionaryUtils;
import org.talend.dataquality.semantic.broadcast.BroadcastDocumentObject;
import org.talend.dataquality.semantic.index.DictionarySearcher;

class BroadcastUtils {
    private BroadcastUtils() {
    }

    static List<BroadcastDocumentObject> readDocumentsFromIndex(Directory indexDir) throws IOException {
        ArrayList<BroadcastDocumentObject> dictionaryObject = new ArrayList<BroadcastDocumentObject>();
        DirectoryReader reader = DirectoryReader.open((Directory)indexDir);
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)reader);
        for (int i = 0; i < reader.maxDoc(); ++i) {
            if (liveDocs != null && !liveDocs.get(i)) continue;
            Document doc = reader.document(i);
            String catId = doc.getField("catid").stringValue();
            HashSet<String> valueSet = new HashSet<String>();
            for (IndexableField syntermField : doc.getFields("raw")) {
                valueSet.add(syntermField.stringValue());
            }
            dictionaryObject.add(new BroadcastDocumentObject(catId, valueSet));
        }
        return dictionaryObject;
    }

    static List<BroadcastDocumentObject> readDocumentsFromIndex(Directory indexDir, Set<String> selectedCategoryIds) throws IOException {
        ArrayList<BroadcastDocumentObject> dictionaryObject = new ArrayList<BroadcastDocumentObject>();
        DirectoryReader reader = DirectoryReader.open((Directory)indexDir);
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)reader);
        for (int i = 0; i < reader.maxDoc(); ++i) {
            Document doc;
            String catId;
            if (liveDocs != null && !liveDocs.get(i) || !selectedCategoryIds.contains(catId = (doc = reader.document(i)).getField("catid").stringValue())) continue;
            HashSet<String> valueSet = new HashSet<String>();
            for (IndexableField syntermField : doc.getFields("raw")) {
                valueSet.add(syntermField.stringValue());
            }
            dictionaryObject.add(new BroadcastDocumentObject(catId, valueSet));
        }
        return dictionaryObject;
    }

    static RAMDirectory createRamDirectoryFromDocuments(List<BroadcastDocumentObject> dictionaryObject) throws IOException {
        RAMDirectory ramDirectory = new RAMDirectory();
        IndexWriterConfig writerConfig = new IndexWriterConfig(Version.LATEST, (Analyzer)new StandardAnalyzer(CharArraySet.EMPTY_SET));
        IndexWriter writer = new IndexWriter((Directory)ramDirectory, writerConfig);
        for (BroadcastDocumentObject objectDoc : dictionaryObject) {
            writer.addDocument((Iterable)BroadcastUtils.createLuceneDocumentFromObject(objectDoc));
        }
        writer.commit();
        writer.close();
        return ramDirectory;
    }

    private static Document createLuceneDocumentFromObject(BroadcastDocumentObject objectDoc) throws IOException {
        Document indexDoc = new Document();
        FieldType ftSyn = new FieldType();
        ftSyn.setStored(false);
        ftSyn.setIndexed(true);
        ftSyn.setOmitNorms(true);
        ftSyn.freeze();
        indexDoc.add((IndexableField)new StringField("catid", objectDoc.getCategory(), Field.Store.YES));
        for (String value : objectDoc.getValueSet()) {
            indexDoc.add((IndexableField)new Field("raw", value, DictionaryUtils.FIELD_TYPE_RAW_VALUE));
            indexDoc.add((IndexableField)new StringField("synterm", DictionarySearcher.getJointTokens(value), Field.Store.NO));
        }
        return indexDoc;
    }
}

