/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.broadcast;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.talend.dataquality.semantic.api.CategoryRegistryManager;
import org.talend.dataquality.semantic.broadcast.BroadcastIndexObject;
import org.talend.dataquality.semantic.broadcast.BroadcastMetadataObject;
import org.talend.dataquality.semantic.broadcast.BroadcastRegexObject;
import org.talend.dataquality.semantic.broadcast.TdqCategories;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedClassifier;
import org.talend.dataquality.semantic.model.DQCategory;

public class TdqCategoriesFactory {
    private static final Logger LOGGER = Logger.getLogger(TdqCategoriesFactory.class);

    public static final TdqCategories createEmptyTdqCategories() {
        return new TdqCategories(null, null, null, null, null);
    }

    public static final TdqCategories createTdqCategories() {
        return TdqCategoriesFactory.createTdqCategories(null);
    }

    public static final TdqCategories createTdqCategories(Set<String> categoryNames) {
        CategoryRegistryManager crm = CategoryRegistryManager.getInstance();
        HashMap<String, DQCategory> selectedCategoryMap = new HashMap<String, DQCategory>();
        for (DQCategory dqCat : crm.listCategories(false)) {
            if (categoryNames != null && !categoryNames.contains(dqCat.getName())) continue;
            selectedCategoryMap.put(dqCat.getId(), dqCat);
        }
        try {
            BroadcastIndexObject keyword;
            BroadcastIndexObject sharedDictionary;
            try (FSDirectory ddDir = FSDirectory.open((File)new File(crm.getDictionaryURI()));){
                sharedDictionary = new BroadcastIndexObject((Directory)ddDir, selectedCategoryMap.keySet());
                LOGGER.debug((Object)"Returning shared dictionary.");
            }
            Directory customDataDictDir = crm.getCustomDictionaryHolder().getDataDictDirectory();
            BroadcastIndexObject customDictionary = new BroadcastIndexObject(customDataDictDir, selectedCategoryMap.keySet());
            LOGGER.debug((Object)"Returning custom dictionary.");
            try (FSDirectory kwDir = FSDirectory.open((File)new File(crm.getKeywordURI()));){
                keyword = new BroadcastIndexObject((Directory)kwDir, selectedCategoryMap.keySet());
                LOGGER.debug((Object)"Returning keywords at path.");
            }
            UserDefinedClassifier classifiers = crm.getCustomDictionaryHolder().getRegexClassifier();
            BroadcastRegexObject regex = new BroadcastRegexObject(classifiers, selectedCategoryMap.keySet());
            LOGGER.debug((Object)"Returning regexes.");
            BroadcastMetadataObject meta = new BroadcastMetadataObject(selectedCategoryMap);
            LOGGER.debug((Object)"Returning category metadata.");
            return new TdqCategories(meta, sharedDictionary, customDictionary, keyword, regex);
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

