/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.classifier.custom;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedClassifier;

public class UDCategorySerDeser {
    private static final Logger LOGGER = Logger.getLogger(UDCategorySerDeser.class);
    private static final String BUNDLE_NAME = "org.talend.dataquality.semantic";
    private static UserDefinedClassifier udc;

    public static UserDefinedClassifier getRegexClassifier() throws IOException {
        if (udc == null) {
            udc = UDCategorySerDeser.readJsonFile();
        }
        return udc;
    }

    static UserDefinedClassifier readJsonFile() throws IOException {
        try {
            InputStream inputStream = UDCategorySerDeser.class.getResourceAsStream("/regex/categorizer.json");
            return UDCategorySerDeser.readJsonFile(inputStream);
        }
        catch (IOException e) {
            LOGGER.warn((Object)e.getMessage(), (Throwable)e);
            URL url = new URL("platform:/plugin/org.talend.dataquality.semantic/regex/categorizer.json");
            InputStream inputStream = url.openConnection().getInputStream();
            return UDCategorySerDeser.readJsonFile(inputStream);
        }
    }

    static UserDefinedClassifier readJsonFile(InputStream inputStream) throws IOException {
        try {
            return (UserDefinedClassifier)new ObjectMapper().readValue(inputStream, UserDefinedClassifier.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    static UserDefinedClassifier readJsonFile(String content) throws IOException {
        try {
            return (UserDefinedClassifier)new ObjectMapper().readValue(content, UserDefinedClassifier.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static UserDefinedClassifier readJsonFile(URI uri) throws IOException {
        InputStream ins = uri.toURL().openStream();
        String content = IOUtils.toString((InputStream)ins);
        IOUtils.closeQuietly((InputStream)ins);
        try {
            JSONArray array = new JSONArray(content);
            JSONObject obj = new JSONObject();
            obj.put("classifiers", array);
            return UDCategorySerDeser.readJsonFile(obj.toString());
        }
        catch (JSONException e) {
            LOGGER.trace((Object)e.getMessage(), (Throwable)e);
            return UDCategorySerDeser.readJsonFile(content);
        }
    }

    public boolean writeToJsonFile(UserDefinedClassifier userDefinedClassifier, OutputStream outputStream) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            mapper.writerWithDefaultPrettyPrinter().writeValue(outputStream, (Object)userDefinedClassifier);
            outputStream.close();
        }
        catch (Exception exc) {
            LOGGER.error((Object)exc.getMessage(), (Throwable)exc);
            return false;
        }
        return true;
    }
}

