/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.classifier.custom;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.talend.dataquality.semantic.exception.DQSemanticRuntimeException;
import org.talend.dataquality.semantic.validator.AbstractRegexSemanticValidator;
import org.talend.dataquality.semantic.validator.ISemanticSubValidator;

public class UserDefinedRegexValidator
extends AbstractRegexSemanticValidator {
    private static final long serialVersionUID = -7832927422566889796L;
    private static final Logger LOG = Logger.getLogger(UserDefinedRegexValidator.class);
    private String patternString;
    private Boolean caseInsensitive = true;
    private String subValidatorClassName = "";
    private ISemanticSubValidator subValidator;
    private boolean isSetSubValidator = false;

    public String getSubValidatorClassName() {
        return this.subValidatorClassName;
    }

    public void setSubValidatorClassName(String subValidatorClassName) {
        this.subValidatorClassName = subValidatorClassName;
        this.subValidator = this.createSubValidator(subValidatorClassName);
        this.isSetSubValidator = this.subValidator != null;
    }

    boolean isSetSubValidator() {
        return this.isSetSubValidator;
    }

    public Boolean getCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(Boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public String getPatternString() {
        return this.patternString;
    }

    public void setPatternString(String patternString) {
        if (StringUtils.isEmpty((CharSequence)patternString)) {
            throw new DQSemanticRuntimeException("null argument of patternString is not allowed.");
        }
        this.patternString = patternString;
        try {
            this.caseInsensitivePattern = this.caseInsensitive != false ? Pattern.compile(patternString, 2) : Pattern.compile(patternString);
            this.caseSensitivePattern = Pattern.compile(patternString);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Invalid regular expression: " + this.patternString), (Throwable)e);
        }
    }

    @Override
    public boolean isValid(String str) {
        return this.isValid(str, false);
    }

    @Override
    public boolean isValid(String str, boolean caseSensitive) {
        if (!super.isValid(str, caseSensitive)) {
            return false;
        }
        return !this.isSetSubValidator || this.validateWithSubValidator(str);
    }

    private ISemanticSubValidator createSubValidator(String validatorName) {
        if (validatorName != null && !validatorName.isEmpty()) {
            try {
                Class<?> subSemanticValidator = Class.forName(validatorName);
                return (ISemanticSubValidator)subSemanticValidator.newInstance();
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)e, (Throwable)e);
            }
            catch (InstantiationException e) {
                LOG.error((Object)e, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e, (Throwable)e);
            }
            this.isSetSubValidator = false;
            this.subValidator = null;
            throw new IllegalArgumentException("Invalid validator class name: " + validatorName);
        }
        return null;
    }

    private boolean validateWithSubValidator(String str) {
        return this.subValidator.isValid(str);
    }
}

