/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.classifier.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.collections.CollectionUtils;
import org.talend.dataquality.semantic.classifier.ISubCategoryClassifier;
import org.talend.dataquality.semantic.index.Index;
import org.talend.dataquality.semantic.model.DQCategory;

public class DataDictFieldClassifier
implements ISubCategoryClassifier {
    private static final long serialVersionUID = 6174669848299972111L;
    private final int MAX_TOKEN_FOR_KEYWORDS = 3;
    private Index sharedDictionary;
    private Index customDictionary;
    private Index keyword;

    public DataDictFieldClassifier(Index sharedDictionary, Index customDictionary, Index keyword) {
        this.sharedDictionary = sharedDictionary;
        this.customDictionary = customDictionary;
        this.keyword = keyword;
    }

    @Override
    public Set<String> classify(String data) {
        StringTokenizer t = new StringTokenizer(data, " ");
        int tokenCount = t.countTokens();
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.sharedDictionary.findCategories(data));
        if (this.customDictionary != null) {
            result.addAll(this.customDictionary.findCategories(data));
        }
        if (tokenCount >= 3) {
            result.addAll(this.keyword.findCategories(data));
        }
        return result;
    }

    @Override
    public boolean validCategories(String data, DQCategory semanticType, Set<DQCategory> children) {
        boolean isValid = false;
        if (CollectionUtils.isEmpty(children)) {
            if (!Boolean.TRUE.equals(semanticType.getDeleted())) {
                isValid = Boolean.TRUE.equals(semanticType.getModified()) ? this.customDictionary.validCategories(data, semanticType, children) : this.sharedDictionary.validCategories(data, semanticType, children);
            }
        } else {
            HashSet<DQCategory> customChildren = new HashSet<DQCategory>();
            HashSet<DQCategory> sharedChildren = new HashSet<DQCategory>();
            children.forEach(child -> {
                if (!Boolean.TRUE.equals(child.getDeleted())) {
                    if (Boolean.TRUE.equals(child.getModified())) {
                        customChildren.add((DQCategory)child);
                    } else {
                        sharedChildren.add((DQCategory)child);
                    }
                }
            });
            if (CollectionUtils.isNotEmpty(customChildren)) {
                isValid = this.customDictionary.validCategories(data, semanticType, customChildren);
            }
            if (!isValid && CollectionUtils.isNotEmpty(sharedChildren)) {
                isValid = this.sharedDictionary.validCategories(data, semanticType, sharedChildren);
            }
        }
        return isValid;
    }

    public void closeIndex() {
        this.sharedDictionary.closeIndex();
        if (this.customDictionary != null) {
            this.customDictionary.closeIndex();
        }
        this.keyword.closeIndex();
    }
}

