/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.index;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.talend.dataquality.semantic.api.CategoryRegistryManager;
import org.talend.dataquality.semantic.index.JARDirectory;
import org.talend.dataquality.semantic.index.PlatformPathUtil;

public class ClassPathDirectory {
    private static final Logger LOGGER = Logger.getLogger(ClassPathDirectory.class);
    private static JARDirectoryProvider provider = new SingletonProvider();

    private ClassPathDirectory() {
    }

    @Deprecated
    public static void setLocalIndexFolder(String folder) {
        CategoryRegistryManager.setLocalRegistryPath(folder);
    }

    public static synchronized void setProvider(JARDirectoryProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Provider can not be null.");
        }
        ClassPathDirectory.provider = provider;
    }

    public static synchronized Directory open(URI uri) {
        if ("jar".equals(uri.getScheme())) {
            LOGGER.info((Object)("Opening '" + uri + "' ..."));
            try {
                return provider.get(uri);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to open JAR '" + uri + "'.", e);
            }
        }
        if ("file".equals(uri.getScheme())) {
            LOGGER.debug((Object)("Opening '" + uri + "' ..."));
            try {
                return FSDirectory.open((File)new File(uri));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to open path '" + uri + "'.", e);
            }
        }
        if ("bundleresource".equals(uri.getScheme())) {
            LOGGER.info((Object)("Opening '" + uri + "' ..."));
            try {
                String path = PlatformPathUtil.getFilePathByPlatformURL(uri.toURL());
                return FSDirectory.open((File)new File(path));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to open bundleresource '" + uri + "'.", e);
            }
        }
        LOGGER.info((Object)("Opening '" + uri + "' ..."));
        throw new UnsupportedOperationException("Unsupported scheme '" + uri.getScheme() + "'.");
    }

    public static void destroy() {
        provider.destroy();
    }

    public static class BasicProvider
    implements JARDirectoryProvider {
        private static final Map<URI, FileSystem> openedJars = new HashMap<URI, FileSystem>();
        private static final Set<JARDirectory> classPathDirectories = new HashSet<JARDirectory>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static FileSystem openOrGet(String uri) throws IOException {
            FileSystem fs;
            URI jarURI = URI.create(uri);
            Map<URI, FileSystem> map = openedJars;
            synchronized (map) {
                fs = openedJars.get(jarURI);
                if (fs == null) {
                    fs = FileSystems.newFileSystem(jarURI, Collections.emptyMap());
                    openedJars.put(jarURI, fs);
                }
            }
            return fs;
        }

        @Override
        public Directory get(URI uri) throws IOException {
            String jarFile = StringUtils.substringBefore((String)uri.toString(), (String)"!");
            String extractionRoot = CategoryRegistryManager.getLocalRegistryPath() + File.separator + "shared" + File.separator + "prod";
            JARDirectory.JARDescriptor openedJar = new JARDirectory.JARDescriptor();
            StringTokenizer tokenizer = new StringTokenizer(uri.toString(), "!");
            FileSystem fs = null;
            while (tokenizer.hasMoreTokens()) {
                String current = tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) break;
                if (fs == null) {
                    fs = BasicProvider.openOrGet(current);
                    continue;
                }
                Path path = fs.getPath(current, new String[0]);
                String unzipFile = extractionRoot + File.separator + path.getFileName();
                Path destFile = Paths.get(unzipFile, new String[0]);
                File destinationFile = destFile.toFile();
                if (!destinationFile.exists()) {
                    destinationFile.mkdirs();
                    Files.copy(path, destFile, StandardCopyOption.REPLACE_EXISTING);
                }
                fs = FileSystems.newFileSystem(destFile, Thread.currentThread().getContextClassLoader());
            }
            openedJar.fileSystem = fs;
            openedJar.jarFileName = jarFile;
            String directory = StringUtils.substringAfterLast((String)uri.toString(), (String)"!");
            LOGGER.debug((Object)("Creating JARDirectory for '" + directory + "' ..."));
            JARDirectory jarDirectory = new JARDirectory(extractionRoot, openedJar, directory);
            classPathDirectories.add(jarDirectory);
            return jarDirectory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroy() {
            Iterator<JARDirectory> iterator = classPathDirectories.iterator();
            while (iterator.hasNext()) {
                JARDirectory jarDirectory = iterator.next();
                try {
                    jarDirectory.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Unable to close directory at " + jarDirectory.indexDirectory + " (location : " + jarDirectory.extractPath + ")."), (Throwable)e);
                }
                finally {
                    iterator.remove();
                }
            }
            for (Map.Entry<URI, FileSystem> entry : openedJars.entrySet()) {
                try {
                    entry.getValue().close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Unable to close " + entry.getValue() + "."), (Throwable)e);
                }
            }
        }
    }

    public static class SingletonProvider
    implements JARDirectoryProvider {
        private static final BasicProvider provider = new BasicProvider();
        private static final Map<URI, Directory> instances = new HashMap<URI, Directory>();

        @Override
        public synchronized Directory get(URI uri) throws IOException {
            Directory dir = instances.get(uri);
            if (dir == null) {
                instances.put(uri, provider.get(uri));
            } else {
                try {
                    dir.listAll();
                }
                catch (AlreadyClosedException e) {
                    LOGGER.debug((Object)"Directory has already been closed. Re-extracting ...", (Throwable)e);
                    instances.put(uri, provider.get(uri));
                }
            }
            return instances.get(uri);
        }

        @Override
        public void destroy() {
            provider.destroy();
        }
    }

    public static interface JARDirectoryProvider {
        public Directory get(URI var1) throws IOException;

        public void destroy();
    }
}

