/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.index;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.talend.dataquality.record.linkage.attribute.LevenshteinMatcher;
import org.talend.dataquality.record.linkage.constant.TokenizedResolutionMethod;
import org.talend.dataquality.semantic.index.DictionarySearchMode;
import org.talend.dataquality.semantic.index.DictionarySearcher;
import org.talend.dataquality.semantic.index.Index;
import org.talend.dataquality.semantic.model.DQCategory;

public class LuceneIndex
implements Index {
    private static final Logger LOG = Logger.getLogger(LuceneIndex.class);
    private final DictionarySearcher searcher;
    private final LevenshteinMatcher levenshtein = new LevenshteinMatcher();

    public LuceneIndex(URI indexPath, DictionarySearchMode searchMode) {
        this(new DictionarySearcher(indexPath), searchMode);
    }

    public LuceneIndex(Directory directory, DictionarySearchMode searchMode) {
        this(new DictionarySearcher(directory), searchMode);
    }

    private LuceneIndex(DictionarySearcher searcher, DictionarySearchMode searchMode) {
        this.searcher = searcher;
        this.searcher.setTopDocLimit(20);
        this.searcher.setSearchMode(searchMode);
        this.searcher.setMaxEdits(2);
        this.levenshtein.setTokenMethod(TokenizedResolutionMethod.NO);
    }

    @Override
    public void setCategoriesToSearch(List<String> categoryIds) {
        this.searcher.setCategoriesToSearch(categoryIds);
    }

    @Override
    public void initIndex() {
        this.searcher.maybeRefreshIndex();
    }

    @Override
    public void closeIndex() {
        this.searcher.close();
    }

    @Override
    public Set<String> findCategories(String data) {
        HashSet<String> foundCategorySet = new HashSet<String>();
        try {
            TopDocs docs = this.searcher.searchDocumentBySynonym(data);
            for (ScoreDoc scoreDoc : docs.scoreDocs) {
                Document document = this.searcher.getDocument(scoreDoc.doc);
                foundCategorySet.add(document.getField("catid").stringValue());
            }
        }
        catch (IOException e) {
            LOG.error((Object)e, (Throwable)e);
        }
        return foundCategorySet;
    }

    @Override
    public boolean validCategories(String data, DQCategory semanticType, Set<DQCategory> children) {
        Boolean validCategory = false;
        try {
            validCategory = this.searcher.validDocumentWithCategories(data, semanticType, children);
        }
        catch (IOException e) {
            LOG.error((Object)e, (Throwable)e);
        }
        return validCategory;
    }

    private static Map<String, Double> sortMapByValue(Map<String, Double> unsortedMap) {
        LinkedList<Map.Entry<String, Double>> list = new LinkedList<Map.Entry<String, Double>>(unsortedMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Double>>(){

            @Override
            public int compare(Map.Entry<String, Double> o1, Map.Entry<String, Double> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        LinkedHashMap<String, Double> sortedMap = new LinkedHashMap<String, Double>();
        for (Map.Entry entry : list) {
            sortedMap.put((String)entry.getKey(), (Double)entry.getValue());
        }
        return sortedMap;
    }

    public Map<String, Double> findSimilarFieldsInCategory(String input, String category, Double similarity) {
        HashMap<String, Double> similarFieldMap = new HashMap<String, Double>();
        try {
            TopDocs docs = this.searcher.findSimilarValuesInCategory(input, category);
            for (ScoreDoc scoreDoc : docs.scoreDocs) {
                IndexableField[] synFields;
                Document doc = this.searcher.getDocument(scoreDoc.doc);
                for (IndexableField synField : synFields = doc.getFields("raw")) {
                    double distance;
                    String synFieldValue = synField.stringValue();
                    if (similarFieldMap.containsKey(synFieldValue) || !((distance = this.calculateOverallSimilarity(input, synFieldValue)) >= similarity)) continue;
                    similarFieldMap.put(synFieldValue, distance);
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage());
        }
        return LuceneIndex.sortMapByValue(similarFieldMap);
    }

    public String findMostSimilarFieldInCategory(String input, String category, double similarity) {
        if (input == null) {
            return null;
        }
        if (category == null) {
            return input;
        }
        String mostSimilarValue = input;
        double highestSimilarity = 0.0;
        try {
            TopDocs docs = this.searcher.findSimilarValuesInCategory(input, category);
            for (ScoreDoc scoreDoc : docs.scoreDocs) {
                IndexableField[] synFields;
                Document doc = this.searcher.getDocument(scoreDoc.doc);
                for (IndexableField synField : synFields = doc.getFields("raw")) {
                    String synFieldValue = synField.stringValue();
                    double currentSimilarity = this.calculateOverallSimilarity(input, synFieldValue);
                    if (!(currentSimilarity >= similarity) || !(currentSimilarity > highestSimilarity)) continue;
                    highestSimilarity = currentSimilarity;
                    mostSimilarValue = synFieldValue;
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return mostSimilarValue;
    }

    private double calculateOverallSimilarity(String input, String field) throws IOException {
        List<String> inputTokens = DictionarySearcher.getTokensFromAnalyzer(input);
        List<String> fieldTokens = DictionarySearcher.getTokensFromAnalyzer(field);
        double bestTokenSimilarity = 0.0;
        for (String inputToken : inputTokens) {
            for (String fieldToken : fieldTokens) {
                double similarity = this.levenshtein.getMatchingWeight(inputToken, fieldToken);
                if (!(similarity > bestTokenSimilarity)) continue;
                bestTokenSimilarity = similarity;
            }
        }
        double fullSimilarity = this.levenshtein.getMatchingWeight(input.toLowerCase(), field.toLowerCase());
        return (bestTokenSimilarity + fullSimilarity) / 2.0;
    }
}

