/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.index;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;

public class PlatformPathUtil {
    private static final Logger LOG = Logger.getLogger(PlatformPathUtil.class);

    private PlatformPathUtil() {
    }

    public static InputStream getInputStreamByPlatformURL(String bundleName, String filePath) throws FileNotFoundException {
        try {
            URL url = new URL("platform:/plugin/" + bundleName + "/" + filePath);
            return url.openConnection().getInputStream();
        }
        catch (MalformedURLException e) {
            return new FileInputStream(filePath);
        }
        catch (IOException e) {
            LOG.error((Object)e);
            return null;
        }
    }

    public static String getFilePathByPlatformURL(String bundleName, String filePath) {
        try {
            URL url = new URL("platform:/plugin/" + bundleName + filePath);
            return PlatformPathUtil.getFilePathByPlatformURL(url);
        }
        catch (MalformedURLException url) {
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
        return filePath;
    }

    public static String getFilePathByPlatformURL(URL url) throws IOException {
        String filePath;
        block3: {
            filePath = url.getPath();
            try {
                url.openConnection().getInputStream();
            }
            catch (FileNotFoundException e) {
                String osFilePath;
                int idx;
                String msg = e.getMessage();
                LOG.warn((Object)msg, (Throwable)e);
                if (filePath.endsWith("/")) {
                    filePath = filePath.substring(0, filePath.length() - 1);
                }
                if ((idx = msg.indexOf(osFilePath = filePath.replace("/", File.separator))) <= 0) break block3;
                return msg.substring(0, idx + filePath.length());
            }
        }
        return filePath;
    }
}

