/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.recognizer;

import java.io.Serializable;
import org.talend.dataquality.semantic.classifier.ISubCategory;
import org.talend.dataquality.semantic.classifier.SemanticCategoryEnum;

public class CategoryFrequency
implements Comparable<CategoryFrequency>,
Serializable {
    private static final long serialVersionUID = -3859689633174391877L;
    String categoryName;
    String categoryLabel;
    long count;
    int categoryLevel;
    float score;

    @Deprecated
    public CategoryFrequency(ISubCategory cat) {
        this(cat.getName(), cat.getName());
    }

    public CategoryFrequency(String categoryName, String categoryLabel) {
        this.categoryName = categoryName;
        this.categoryLabel = categoryLabel;
    }

    public CategoryFrequency(String categoryName, String categoryLabel, long count) {
        this.categoryName = categoryName;
        this.categoryLabel = categoryLabel;
        this.categoryLevel = 0;
        this.count = count;
    }

    public CategoryFrequency(String categoryName, String categoryLabel, int categoryLevel) {
        this.categoryName = categoryName;
        this.categoryLabel = categoryLabel;
        this.categoryLevel = categoryLevel;
    }

    public String getCategoryId() {
        return this.categoryName;
    }

    public String getCategoryName() {
        return this.categoryLabel != null ? this.categoryLabel : this.categoryName;
    }

    public float getFrequency() {
        return this.score;
    }

    public long getCount() {
        return this.count;
    }

    public int getCategoryLevel() {
        return this.categoryLevel;
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CategoryFrequency)) {
            return false;
        }
        CategoryFrequency that = (CategoryFrequency)o;
        return !(this.getCategoryId() == null ? that.getCategoryId() != null : !this.getCategoryId().equals(that.getCategoryId()));
    }

    public int hashCode() {
        return this.getCategoryId() != null ? this.getCategoryId().hashCode() : 0;
    }

    @Override
    public int compareTo(CategoryFrequency o) {
        int count = Float.compare(this.getScore(), o.getScore());
        if (count != 0) {
            return count;
        }
        int level = -Integer.compare(this.getCategoryLevel(), o.getCategoryLevel());
        if (level != 0) {
            return level;
        }
        SemanticCategoryEnum cat1 = SemanticCategoryEnum.getCategoryById(this.getCategoryId());
        SemanticCategoryEnum cat2 = SemanticCategoryEnum.getCategoryById(o.getCategoryId());
        if (cat1 != null && cat2 != null) {
            return cat2.ordinal() - cat1.ordinal();
        }
        if (cat1 == null && cat2 != null) {
            return 1;
        }
        if (cat2 == null && cat1 != null) {
            return -1;
        }
        return o.getCategoryId().compareTo(this.getCategoryId());
    }

    public String toString() {
        return "[Category: " + this.categoryName + " Count: " + this.count + " Score: " + this.score + "]";
    }
}

