/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.recognizer;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.store.Directory;
import org.talend.dataquality.semantic.api.CategoryRegistryManager;
import org.talend.dataquality.semantic.classifier.custom.UserDefinedClassifier;
import org.talend.dataquality.semantic.index.ClassPathDirectory;
import org.talend.dataquality.semantic.index.DictionarySearchMode;
import org.talend.dataquality.semantic.index.LuceneIndex;
import org.talend.dataquality.semantic.model.DQCategory;
import org.talend.dataquality.semantic.recognizer.CategoryRecognizer;
import org.talend.dataquality.semantic.recognizer.DefaultCategoryRecognizer;
import org.talend.dataquality.semantic.recognizer.DictionaryConstituents;

public class CategoryRecognizerBuilder {
    private static final Logger LOGGER = Logger.getLogger(CategoryRecognizerBuilder.class);
    public static final String DEFAULT_METADATA_PATH = "/metadata/";
    public static final String DEFAULT_DD_PATH = "/dictionary/";
    public static final String DEFAULT_KW_PATH = "/keyword/";
    public static final String DEFAULT_RE_PATH = "/regex/categorizer.json";
    private Mode mode;
    private LuceneIndex sharedDataDictIndex;
    private LuceneIndex customDataDictIndex;
    private LuceneIndex keywordIndex;
    private Directory sharedDataDictDirectory;
    private Directory customDataDictDirectory;
    private Directory keywordDirectory;
    private UserDefinedClassifier regexClassifier;
    private Map<String, DQCategory> metadata;
    private String tenantID = "t_default";
    private DictionaryConstituents constituents;

    public static CategoryRecognizerBuilder newBuilder() {
        return new CategoryRecognizerBuilder();
    }

    public CategoryRecognizerBuilder tenantID(String tenantID) {
        this.tenantID = tenantID;
        return this;
    }

    public CategoryRecognizerBuilder metadata(Map<String, DQCategory> metadata) {
        this.metadata = metadata;
        return this;
    }

    public CategoryRecognizerBuilder ddDirectory(Directory sharedDataDictDirectory) {
        this.sharedDataDictDirectory = sharedDataDictDirectory;
        return this;
    }

    public CategoryRecognizerBuilder ddCustomDirectory(Directory customDataDictDirectory) {
        this.customDataDictDirectory = customDataDictDirectory;
        return this;
    }

    public CategoryRecognizerBuilder kwDirectory(Directory keywordDirectory) {
        this.keywordDirectory = keywordDirectory;
        return this;
    }

    public CategoryRecognizerBuilder regexClassifier(UserDefinedClassifier regexClassifier) {
        this.regexClassifier = regexClassifier;
        return this;
    }

    public CategoryRecognizerBuilder lucene() {
        this.mode = Mode.LUCENE;
        return this;
    }

    public CategoryRecognizer build() throws IOException {
        switch (this.mode) {
            case LUCENE: {
                return new DefaultCategoryRecognizer(this.getDictionaryConstituents());
            }
            case ELASTIC_SEARCH: {
                throw new IllegalArgumentException("Elasticsearch mode is not supported any more");
            }
        }
        throw new IllegalArgumentException("no mode specified.");
    }

    public DictionaryConstituents getDictionaryConstituents() {
        if (this.constituents == null) {
            Map<String, DQCategory> meta = this.getCategoryMetadata();
            LuceneIndex sharedDataDict = this.getSharedDataDictIndex();
            LuceneIndex customDataDict = this.getCustomDataDictIndex();
            LuceneIndex keyword = this.getKeywordIndex();
            UserDefinedClassifier regex = this.getRegexClassifier();
            this.constituents = new DictionaryConstituents(meta, sharedDataDict, customDataDict, keyword, regex);
        } else {
            this.constituents.setMetadata(this.getCategoryMetadata());
            this.constituents.getCustomDataDict().initIndex();
            this.constituents.setRegexClassifier(this.getRegexClassifier());
        }
        return this.constituents;
    }

    public Map<String, DQCategory> getCategoryMetadata() {
        if (this.metadata == null) {
            return CategoryRegistryManager.getInstance().getCustomDictionaryHolder(this.tenantID).getMetadata();
        }
        return this.metadata;
    }

    private LuceneIndex getSharedDataDictIndex() {
        if (this.sharedDataDictIndex == null) {
            if (this.sharedDataDictDirectory == null) {
                this.sharedDataDictDirectory = CategoryRegistryManager.getInstance().getSharedDataDictDirectory();
            }
            this.sharedDataDictIndex = new LuceneIndex(this.sharedDataDictDirectory, DictionarySearchMode.MATCH_SEMANTIC_DICTIONARY);
        }
        return this.sharedDataDictIndex;
    }

    private LuceneIndex getCustomDataDictIndex() {
        if (this.customDataDictIndex == null) {
            if (this.customDataDictDirectory == null) {
                Directory dir = CategoryRegistryManager.getInstance().getCustomDictionaryHolder(this.tenantID).getDataDictDirectory();
                if (dir != null) {
                    this.customDataDictIndex = new LuceneIndex(dir, DictionarySearchMode.MATCH_SEMANTIC_DICTIONARY);
                }
            } else {
                this.customDataDictIndex = new LuceneIndex(this.customDataDictDirectory, DictionarySearchMode.MATCH_SEMANTIC_DICTIONARY);
            }
        }
        return this.customDataDictIndex;
    }

    private LuceneIndex getKeywordIndex() {
        if (this.keywordIndex == null) {
            try {
                if (this.keywordDirectory == null) {
                    this.keywordDirectory = ClassPathDirectory.open(CategoryRegistryManager.getInstance().getKeywordURI());
                }
                this.keywordIndex = new LuceneIndex(this.keywordDirectory, DictionarySearchMode.MATCH_SEMANTIC_KEYWORD);
            }
            catch (URISyntaxException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.keywordIndex;
    }

    private UserDefinedClassifier getRegexClassifier() {
        if (this.regexClassifier == null) {
            try {
                return CategoryRegistryManager.getInstance().getCustomDictionaryHolder(this.tenantID).getRegexClassifier();
            }
            catch (IOException e) {
                LOGGER.error((Object)"Failed to load provided regex classifiers", (Throwable)e);
            }
        }
        return this.regexClassifier;
    }

    public Mode getMode() {
        return this.mode;
    }

    public static enum Mode {
        LUCENE,
        ELASTIC_SEARCH;

    }
}

