/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.recognizer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class LFUCache<K, V>
implements Map<K, V> {
    private final Map<K, CacheNode<K, V>> cache;
    private final LinkedHashSet<CacheNode<K, V>>[] frequencyList;
    private int lowestFrequency;
    private int maxFrequency;
    private final int maxCacheSize;
    private final float evictionFactor;

    public LFUCache(int initialCacheSize, int maxCacheSize, float evictionFactor) {
        if (evictionFactor <= 0.0f || evictionFactor >= 1.0f) {
            throw new IllegalArgumentException("Eviction factor must be greater than 0 and lesser than or equal to 1");
        }
        this.cache = new HashMap<K, CacheNode<K, V>>(initialCacheSize);
        this.frequencyList = new LinkedHashSet[maxCacheSize];
        this.lowestFrequency = 0;
        this.maxFrequency = maxCacheSize - 1;
        this.maxCacheSize = maxCacheSize;
        this.evictionFactor = evictionFactor;
        this.initFrequencyList();
    }

    @Override
    public V put(K k, V v) {
        Object oldValue = null;
        CacheNode<K, V> currentNode = this.cache.get(k);
        if (currentNode == null) {
            if (this.cache.size() == this.maxCacheSize) {
                this.doEviction();
            }
            LinkedHashSet<CacheNode<K, V>> nodes = this.frequencyList[0];
            currentNode = new CacheNode<K, V>(k, v, 0);
            nodes.add(currentNode);
            this.cache.put(k, currentNode);
            this.lowestFrequency = 0;
        } else {
            oldValue = ((CacheNode)currentNode).v;
            ((CacheNode)currentNode).v = v;
        }
        return (V)oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> me : map.entrySet()) {
            this.put(me.getKey(), me.getValue());
        }
    }

    @Override
    public V get(Object k) {
        CacheNode<K, V> currentNode = this.cache.get(k);
        if (currentNode != null) {
            int currentFrequency = ((CacheNode)currentNode).frequency;
            if (currentFrequency < this.maxFrequency) {
                int nextFrequency = currentFrequency + 1;
                LinkedHashSet<CacheNode<K, V>> currentNodes = this.frequencyList[currentFrequency];
                LinkedHashSet<CacheNode<K, V>> newNodes = this.frequencyList[nextFrequency];
                this.moveToNextFrequency(currentNode, nextFrequency, currentNodes, newNodes);
                this.cache.put(k, currentNode);
                if (this.lowestFrequency == currentFrequency && currentNodes.isEmpty()) {
                    this.lowestFrequency = nextFrequency;
                }
            } else {
                LinkedHashSet<CacheNode<K, V>> nodes = this.frequencyList[currentFrequency];
                nodes.remove(currentNode);
                nodes.add(currentNode);
            }
            return (V)((CacheNode)currentNode).v;
        }
        return null;
    }

    @Override
    public V remove(Object k) {
        CacheNode<K, V> currentNode = this.cache.remove(k);
        if (currentNode != null) {
            LinkedHashSet<CacheNode<K, V>> nodes = this.frequencyList[((CacheNode)currentNode).frequency];
            nodes.remove(currentNode);
            if (this.lowestFrequency == ((CacheNode)currentNode).frequency) {
                this.findNextLowestFrequency();
            }
            return (V)((CacheNode)currentNode).v;
        }
        return null;
    }

    public int frequencyOf(K k) {
        CacheNode<K, V> node = this.cache.get(k);
        if (node != null) {
            return ((CacheNode)node).frequency + 1;
        }
        return 0;
    }

    @Override
    public void clear() {
        for (int i = 0; i <= this.maxFrequency; ++i) {
            this.frequencyList[i].clear();
        }
        this.cache.clear();
        this.lowestFrequency = 0;
    }

    @Override
    public Set<K> keySet() {
        return this.cache.keySet();
    }

    @Override
    public Collection<V> values() {
        return null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return null;
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.cache.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return false;
    }

    private void initFrequencyList() {
        for (int i = 0; i <= this.maxFrequency; ++i) {
            this.frequencyList[i] = new LinkedHashSet();
        }
    }

    private void doEviction() {
        int currentlyDeleted = 0;
        float target = (float)this.maxCacheSize * this.evictionFactor;
        while ((float)currentlyDeleted < target) {
            LinkedHashSet<CacheNode<K, V>> nodes = this.frequencyList[this.lowestFrequency];
            if (nodes.isEmpty()) {
                throw new IllegalStateException("Lowest frequency constraint violated!");
            }
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                int n = currentlyDeleted++;
                if (!((float)n < target)) break;
                CacheNode node = (CacheNode)it.next();
                it.remove();
                this.cache.remove(node.k);
            }
            if (it.hasNext()) continue;
            this.findNextLowestFrequency();
        }
    }

    private void moveToNextFrequency(CacheNode<K, V> currentNode, int nextFrequency, LinkedHashSet<CacheNode<K, V>> currentNodes, LinkedHashSet<CacheNode<K, V>> newNodes) {
        currentNodes.remove(currentNode);
        newNodes.add(currentNode);
        ((CacheNode)currentNode).frequency = nextFrequency;
    }

    private void findNextLowestFrequency() {
        while (this.lowestFrequency <= this.maxFrequency && this.frequencyList[this.lowestFrequency].isEmpty()) {
            ++this.lowestFrequency;
        }
        if (this.lowestFrequency > this.maxFrequency) {
            this.lowestFrequency = 0;
        }
    }

    public String toString() {
        return this.cache.toString();
    }

    private static class CacheNode<Key, Value> {
        private final Key k;
        private Value v;
        private int frequency;

        public CacheNode(Key k, Value v, int frequency) {
            this.k = k;
            this.v = v;
            this.frequency = frequency;
        }

        public String toString() {
            return "[" + this.v + "->" + this.frequency + "]";
        }
    }
}

