/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.sampling;

import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SemanticCategory {
    public static final SemanticCategory EMPTY = new SemanticCategory("", "", 0L, 0.0);
    private static final Logger LOGGER = Logger.getLogger(SemanticCategory.class);
    private final String semanticCategoryId;
    private String semanticName;
    private long count = 0L;
    private double frequency = 0.0;
    private boolean isTextFieldValue = false;

    public SemanticCategory(String categoryId, String categoryName, long count, double freq) {
        if (categoryName == null) {
            LOGGER.error((Object)"ERROR: category name is null.");
        }
        assert (categoryName != null) : "category name is null for " + categoryId;
        this.semanticCategoryId = categoryId;
        this.count = count;
        this.frequency = freq;
        this.semanticName = categoryName;
    }

    public String getSemanticCategoryID() {
        return this.semanticCategoryId;
    }

    public String getSemanticName() {
        return this.semanticName;
    }

    public void setSemanticName(String semanticName) {
        this.semanticName = semanticName;
    }

    public long getCount() {
        return this.count;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public String toString() {
        if (this.isNotShowFrequency()) {
            return this.semanticName;
        }
        return this.formatStr();
    }

    private String formatStr() {
        StringBuilder strBuf = new StringBuilder();
        strBuf.append(this.semanticName);
        if (Double.compare(this.frequency, 0.0) == 0) {
            strBuf.append("                       (previous match)");
        } else {
            for (int index = strBuf.length(); index < Math.max(2, 50 - this.semanticName.length()); ++index) {
                strBuf.append(" ");
            }
            if (this.frequency >= 1.0) {
                strBuf.append((int)Math.floor(this.frequency));
                strBuf.append("%");
            } else {
                strBuf.append("<1%");
            }
        }
        return strBuf.toString();
    }

    private boolean isNotShowFrequency() {
        return this.frequency < 0.0 || StringUtils.isBlank((CharSequence)this.semanticCategoryId) || this.isTextFieldValue;
    }

    public SemanticCategory clone() {
        try {
            return (SemanticCategory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.info((Object)e);
            return new SemanticCategory(this.semanticCategoryId, this.semanticName, this.count, this.frequency);
        }
    }

    public boolean isTextFieldValue() {
        return this.isTextFieldValue;
    }

    public void setTextFieldValue(boolean isShowTextFieldValue) {
        this.isTextFieldValue = isShowTextFieldValue;
    }
}

