/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.semantic.sampling;

import java.util.List;
import java.util.Map;
import org.talend.dataquality.semantic.exception.DQException;
import org.talend.dataquality.semantic.sampling.CategoryInferenceManager;
import org.talend.dataquality.semantic.sampling.SemanticCategory;

public class SemanticCategoryRecognizerBridge {
    private CategoryInferenceManager manager;
    private List<Object[]> sampleDataCache;
    private int recordCursor = 0;
    private boolean stopRequested = false;

    public SemanticCategoryRecognizerBridge(List<Object[]> sampleDataCache) {
        this.sampleDataCache = sampleDataCache;
        this.manager = new CategoryInferenceManager();
    }

    public void inferSemanticCategories() throws DQException {
        if (this.sampleDataCache != null) {
            for (Object[] record : this.sampleDataCache) {
                if (this.stopRequested) {
                    return;
                }
                this.manager.inferCategory(record);
                ++this.recordCursor;
            }
        }
    }

    public Map<Integer, List<SemanticCategory>> getSemanticCategory() {
        return this.manager.getSemanticCategory();
    }

    public int getRecordCursor() {
        return this.recordCursor;
    }

    public boolean isStopRequested() {
        return this.stopRequested;
    }

    public void setStopRequested(boolean stopRequested) {
        this.stopRequested = stopRequested;
    }
}

