/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.standardization.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.TopDocs;
import org.talend.dataquality.standardization.action.ITalendStrConversionAction;
import org.talend.dataquality.standardization.index.SynonymIndexSearcher;

public class SynonymReplaceAction
implements ITalendStrConversionAction {
    private static final Logger LOG = Logger.getLogger(SynonymReplaceAction.class);
    private Map<String, SynonymIndexSearcher> synonymSearcherMap;

    @Override
    public String run(String str, int modifCount, String extraParameter, Random random) {
        if (str.length() > 0) {
            SynonymIndexSearcher searcher = this.getSynonymSearcherMap().get(extraParameter);
            if (searcher == null) {
                searcher = new SynonymIndexSearcher(extraParameter);
                this.synonymSearcherMap.put(extraParameter, searcher);
            }
            try {
                TopDocs docs = searcher.searchDocumentBySynonym(str);
                if (docs.totalHits > 0) {
                    String[] synonyms;
                    Document doc = searcher.getDocument(docs.scoreDocs[0].doc);
                    ArrayList<String> replaceList = new ArrayList<String>();
                    String word = doc.getValues("word")[0];
                    if (!word.equalsIgnoreCase(str)) {
                        replaceList.add(word);
                    }
                    for (String syn : synonyms = doc.getValues("syn")) {
                        if (syn.equalsIgnoreCase(str)) continue;
                        replaceList.add(syn);
                    }
                    if (replaceList.isEmpty()) {
                        return str;
                    }
                    return (String)replaceList.get(random.nextInt(replaceList.size()));
                }
            }
            catch (IOException e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        return "";
    }

    private Map<String, SynonymIndexSearcher> getSynonymSearcherMap() {
        if (this.synonymSearcherMap == null) {
            this.synonymSearcherMap = new HashMap<String, SynonymIndexSearcher>();
        }
        return this.synonymSearcherMap;
    }

    public void closeSynonymIndice() {
        if (this.synonymSearcherMap != null && !this.synonymSearcherMap.isEmpty()) {
            for (SynonymIndexSearcher searcher : this.synonymSearcherMap.values()) {
                searcher.close();
            }
            this.synonymSearcherMap.clear();
        }
    }
}

