/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.standardization.index;

import com.talend.csv.CSVReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.util.Version;
import org.talend.dataquality.standardization.i18n.Messages;
import org.talend.dataquality.standardization.index.SynonymIndexBuilder;

public class IndexBuilder {
    private static final Logger LOG = Logger.getLogger(SynonymIndexBuilder.class);
    private String directoryPath;
    private Directory index;

    public Directory getIndex() {
        return this.index;
    }

    public IndexBuilder(String directoryPath) {
        this.directoryPath = directoryPath;
    }

    public IndexBuilder() {
    }

    public boolean initializeIndex(String csvFileToIndex, int[] columnsToBeIndexed) throws IOException {
        assert (csvFileToIndex != null);
        if (!new File(csvFileToIndex).exists() || !new File(this.directoryPath).isDirectory()) {
            throw new IOException(Messages.getString("IndexBuilder.error", csvFileToIndex, this.directoryPath));
        }
        this.index = new MMapDirectory(new File(this.directoryPath));
        StandardAnalyzer analyzer = new StandardAnalyzer();
        IndexWriterConfig config = new IndexWriterConfig(Version.LATEST, (Analyzer)analyzer);
        IndexWriter w = new IndexWriter(this.index, config);
        CSVReader csvReader = this.createCSVReader(csvFileToIndex, ',');
        while (csvReader.readNext()) {
            String name = csvReader.get(columnsToBeIndexed[0]);
            String country = csvReader.get(columnsToBeIndexed[1]);
            String gender = csvReader.get(columnsToBeIndexed[2]);
            String count = csvReader.get(columnsToBeIndexed[3]);
            IndexBuilder.addDoc(w, name, country, gender, count);
        }
        csvReader.close();
        w.commit();
        w.close();
        return true;
    }

    private static void addDoc(IndexWriter w, String name, String country, String gender, String count) throws IOException {
        if (!"".equals(country) && !"".equals(gender)) {
            Document doc = new Document();
            Field field = new Field("name", name, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.YES);
            doc.add((IndexableField)field);
            doc.add((IndexableField)new Field("country", country, Field.Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.YES));
            doc.add((IndexableField)new Field("gender", gender, Field.Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.YES));
            doc.add((IndexableField)new Field("count", count, Field.Store.NO, Field.Index.NOT_ANALYZED, Field.TermVector.NO));
            w.addDocument((Iterable)doc);
        }
    }

    public boolean initializeSynonymIndex(String csvFileToIndex, int[] columnsToBeIndexed) throws IOException {
        assert (csvFileToIndex != null);
        if (!new File(csvFileToIndex).exists() || !new File(this.directoryPath).isDirectory()) {
            throw new IOException(Messages.getString("IndexBuilder.error", csvFileToIndex, this.directoryPath));
        }
        this.index = FSDirectory.open((File)new File(this.directoryPath));
        StandardAnalyzer analyzer = new StandardAnalyzer();
        IndexWriterConfig config = new IndexWriterConfig(Version.LATEST, (Analyzer)analyzer);
        IndexWriter w = new IndexWriter(this.index, config);
        CSVReader csvReader = this.createCSVReader(csvFileToIndex, ';');
        while (csvReader.readNext()) {
            String[] split;
            Document doc = new Document();
            String word = csvReader.get(columnsToBeIndexed[0]);
            doc.add((IndexableField)new Field("word", word, Field.Store.YES, Field.Index.NO, Field.TermVector.NO));
            doc.add((IndexableField)new Field("syn", word, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.YES));
            if (columnsToBeIndexed.length == 1) {
                w.addDocument((Iterable)doc);
                continue;
            }
            String synonyms = csvReader.get(columnsToBeIndexed[1]);
            for (String str : split = StringUtils.split((String)synonyms, (String)"|")) {
                doc.add((IndexableField)new Field("syn", str, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.YES));
            }
            w.addDocument((Iterable)doc);
        }
        csvReader.close();
        w.commit();
        w.close();
        return true;
    }

    private CSVReader createCSVReader(String csvFileToIndex, char seperator) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        CSVReader csvReader = new CSVReader((Reader)new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(csvFileToIndex.toString()), "windows-1252")), seperator);
        csvReader.setQuoteChar('\"');
        csvReader.readNext();
        return csvReader;
    }

    private static void createSynonymIndex(String indexPath, String sourceFile) {
        File dirFile = new File("data/indexes/" + indexPath);
        if (!dirFile.exists() && !dirFile.isDirectory()) {
            dirFile.mkdirs();
        }
        IndexBuilder ib = new IndexBuilder("data/indexes/" + indexPath);
        int[] columnsToIndex = new int[]{0, 1};
        try {
            ib.initializeSynonymIndex("data/indexes/" + sourceFile, columnsToIndex);
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
    }

    private static void createSingleIndex(String indexPath, String sourceFile) {
        File dirFile = new File("data/indexes/" + indexPath);
        if (!dirFile.exists() && !dirFile.isDirectory()) {
            dirFile.mkdirs();
        }
        IndexBuilder ib = new IndexBuilder("data/indexes/" + indexPath);
        int[] columnsToIndex = new int[]{0};
        try {
            ib.initializeSynonymIndex("data/indexes/" + sourceFile, columnsToIndex);
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
    }

    public static void main(String[] args) throws IOException {
        IndexBuilder.createSynonymIndex("Salutory", "SalutorySynonyms.csv");
        IndexBuilder.createSynonymIndex("Address", "AddressSynonyms.csv");
        IndexBuilder.createSingleIndex("Company", "CompanySynonyms.csv");
        IndexBuilder.createSynonymIndex("StreetType", "StreetTypeSynonyms.csv");
    }
}

