/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.standardization.index;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.talend.dataquality.standardization.i18n.Messages;
import org.talend.dataquality.standardization.index.Error;
import org.talend.dataquality.standardization.index.SynonymIndexSearcher;

public class SynonymIndexBuilder {
    private static final Logger LOG = Logger.getLogger(SynonymIndexBuilder.class);
    private Directory indexDir;
    private char separator = (char)124;
    private Analyzer analyzer;
    private IndexWriter writer;
    private final Error error = new Error();

    public Error getError() {
        return this.error;
    }

    public void setSynonymSeparator(char synonymSeparator) {
        this.separator = synonymSeparator;
    }

    public void initIndexInFS(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            this.indexDir = FSDirectory.open((File)file);
        }
        catch (IOException e) {
            this.error.set(false, Messages.getString("SynonymIndexBuilder.failLoad"));
        }
    }

    public boolean insertDocument(String word, String synonyms) throws IOException {
        if (word.length() == 0) {
            this.error.set(false, Messages.getString("SynonymIndexBuilder.noRef"));
            return false;
        }
        this.getWriter().addDocument((Iterable)this.generateDocument(word, synonyms));
        return true;
    }

    public boolean insertDocumentIfNotExists(String word, String synonyms) throws IOException {
        if (this.searchDocumentByWord((String)word).totalHits == 0) {
            this.getWriter().addDocument((Iterable)this.generateDocument(word, synonyms));
            return true;
        }
        this.error.set(false, Messages.getString("SynonymIndexBuilder.aDocument", word));
        return false;
    }

    public int updateDocument(String word, String synonyms) throws IOException {
        int nbUpdatedDocuments = 0;
        TopDocs docs = this.searchDocumentByWord(word);
        switch (docs.totalHits) {
            case 0: {
                break;
            }
            case 1: {
                this.getWriter().updateDocument(new Term("wordterm", word.trim().toLowerCase()), (Iterable)this.generateDocument(word, synonyms));
                nbUpdatedDocuments = 1;
                break;
            }
            default: {
                nbUpdatedDocuments = -1;
                this.error.set(false, Messages.getString("SynonymIndexBuilder.documents", docs.totalHits, word));
            }
        }
        return nbUpdatedDocuments;
    }

    public int deleteDocumentByWord(String word) throws IOException {
        TopDocs docs = this.searchDocumentByWord(word);
        switch (docs.totalHits) {
            case 0: {
                this.error.set(false, Messages.getString("SynonymIndexBuilder.doesnotExsit", word));
                return 0;
            }
            case 1: {
                this.getWriter().deleteDocuments(new Term[]{new Term("wordterm", word.trim().toLowerCase())});
                return 1;
            }
        }
        this.error.set(false, Messages.getString("SynonymIndexBuilder.documents", docs.totalHits, word));
        return 0;
    }

    public void deleteAllDocuments() throws IOException {
        this.getWriter().deleteAll();
    }

    public int addSynonymToDocument(String word, String newSynonym) throws IOException {
        if (newSynonym == null) {
            return 0;
        }
        String tempSynonym = newSynonym.trim();
        if (tempSynonym.length() == 0) {
            return 0;
        }
        SynonymIndexSearcher idxSearcher = this.getNewSynIdxSearcher();
        TopDocs docs = idxSearcher.searchDocumentByWord(word);
        int nbDocs = 0;
        switch (docs.totalHits) {
            case 0: {
                this.error.set(false, Messages.getString("SynonymIndexBuilder.document", word));
                break;
            }
            case 1: {
                Document doc = idxSearcher.getDocument(docs.scoreDocs[0].doc);
                String[] synonyms = doc.getValues("syn");
                HashSet<String> synonymList = new HashSet<String>();
                boolean synExists = false;
                if (tempSynonym.equalsIgnoreCase(word)) {
                    synExists = true;
                }
                for (String str : synonyms) {
                    if (str.equalsIgnoreCase(tempSynonym)) {
                        synExists = true;
                    }
                    synonymList.add(str);
                }
                if (synExists) break;
                synonymList.add(tempSynonym);
                doc = this.generateDocument(doc.getValues("word")[0], synonymList);
                this.getWriter().updateDocument(new Term("wordterm", word.trim().toLowerCase()), (Iterable)doc);
                nbDocs = 1;
                break;
            }
            default: {
                this.error.set(false, Messages.getString("SynonymIndexBuilder.documents", docs.totalHits, word));
            }
        }
        idxSearcher.close();
        return nbDocs;
    }

    public int removeSynonymFromDocument(String word, String synonymToDelete) throws IOException {
        if (synonymToDelete == null) {
            this.error.set(false, Messages.getString("SynonymIndexBuilder.theSynonym", word));
            return 0;
        }
        String tempSynonymToDelete = synonymToDelete.trim();
        if (tempSynonymToDelete.equalsIgnoreCase(word)) {
            this.error.set(false, Messages.getString("SynonymIndexBuilder.synonymToDelete", tempSynonymToDelete, word));
            return 0;
        }
        int deleted = 0;
        SynonymIndexSearcher newSynIdxSearcher = this.getNewSynIdxSearcher();
        TopDocs docs = newSynIdxSearcher.searchDocumentByWord(word);
        switch (docs.totalHits) {
            case 0: {
                this.error.set(false, Messages.getString("SynonymIndexBuilder.documentNotExsit", word));
                deleted = 0;
                break;
            }
            case 1: {
                Document doc = newSynIdxSearcher.getDocument(docs.scoreDocs[0].doc);
                String[] synonyms = doc.getValues("syn");
                HashSet<String> synonymList = new HashSet<String>();
                for (String str : synonyms) {
                    if (str.equals(word)) continue;
                    if (str.equalsIgnoreCase(tempSynonymToDelete)) {
                        ++deleted;
                        continue;
                    }
                    synonymList.add(str);
                }
                if (deleted == 0) {
                    this.error.set(false, Messages.getString("SynonymIndexBuilder.synonymNotExsit", tempSynonymToDelete));
                    break;
                }
                doc = this.generateDocument(doc.getValues("word")[0], synonymList);
                this.getWriter().updateDocument(new Term("wordterm", word.toLowerCase()), (Iterable)doc);
                break;
            }
            default: {
                this.error.set(false, Messages.getString("SynonymIndexBuilder.documents", docs.totalHits, word));
            }
        }
        newSynIdxSearcher.close();
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteIndexFromFS(String path) {
        File folder = new File(path);
        if (!folder.exists()) {
            return true;
        }
        if (folder.isDirectory()) {
            File[] filelist = folder.listFiles();
            if (filelist.length == 0) {
                if (!folder.delete()) {
                    this.error.set(false, Messages.getString("SynonymIndexBuilder.couldNotDelete", folder.getAbsolutePath()));
                    return false;
                }
            } else {
                CheckIndex.Status status = null;
                try (FSDirectory directory = null;){
                    directory = FSDirectory.open((File)folder);
                    CheckIndex check = new CheckIndex((Directory)directory);
                    status = check.checkIndex();
                }
                boolean allDeleted = true;
                if (status == null || status.missingSegments) {
                    this.error.set(false, Messages.getString("SynonymIndexBuilder.notAnIndexFolder", folder.getAbsolutePath()));
                    return false;
                }
                for (File f : filelist) {
                    if (f.delete() || !allDeleted) continue;
                    allDeleted = false;
                }
                if (allDeleted && !folder.delete()) {
                    allDeleted = false;
                }
                if (!allDeleted) {
                    this.error.set(false, Messages.getString("SynonymIndexBuilder.couldNotDelete", folder.getAbsolutePath()));
                    return false;
                }
            }
        } else {
            this.error.set(false, Messages.getString("SynonymIndexBuilder.pathIsFile", folder.getAbsolutePath()));
            return false;
        }
        return true;
    }

    public void closeIndex() {
        try {
            this.getWriter().close();
        }
        catch (CorruptIndexException e) {
            LOG.error((Object)e);
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
    }

    public void commit() {
        try {
            this.getWriter().commit();
        }
        catch (CorruptIndexException e) {
            this.error.set(false, e.getMessage());
            LOG.error((Object)e);
        }
        catch (IOException e) {
            this.error.set(false, e.getMessage());
            LOG.error((Object)e);
        }
    }

    public Analyzer getAnalyzer() throws IOException {
        if (this.analyzer == null) {
            this.analyzer = new StandardAnalyzer(CharArraySet.EMPTY_SET);
        }
        return this.analyzer;
    }

    IndexWriter getWriter() throws IOException {
        if (this.writer == null) {
            IndexWriterConfig config = new IndexWriterConfig(Version.LATEST, this.getAnalyzer());
            this.writer = new IndexWriter(this.indexDir, config);
        }
        return this.writer;
    }

    public int getNumDocs() {
        try {
            return this.getWriter().numDocs();
        }
        catch (IOException e) {
            LOG.error((Object)e);
            return -1;
        }
    }

    private SynonymIndexSearcher getNewSynIdxSearcher() throws IOException {
        return new SynonymIndexSearcher(this.indexDir);
    }

    private Document generateDocument(String word, String synonyms) {
        HashSet<String> set = new HashSet<String>();
        if (synonyms != null) {
            StringTokenizer tokenizer = new StringTokenizer(synonyms, String.valueOf(this.separator));
            while (tokenizer.hasMoreTokens()) {
                set.add(tokenizer.nextToken());
            }
        }
        return this.generateDocument(word, set);
    }

    private Document generateDocument(String word, Set<String> synonyms) {
        String tempWord = word.trim();
        Document doc = new Document();
        FieldType ft = new FieldType();
        ft.setStored(true);
        ft.setIndexed(true);
        ft.setOmitNorms(true);
        ft.freeze();
        Field wordField = new Field("word", tempWord, ft);
        doc.add((IndexableField)wordField);
        StringField wordTermField = new StringField("wordterm", tempWord.toLowerCase(), Field.Store.NO);
        doc.add((IndexableField)wordTermField);
        for (String syn : synonyms) {
            if (syn == null || (syn = syn.trim()).length() <= 0 || syn.equals(tempWord)) continue;
            doc.add((IndexableField)new Field("syn", syn, ft));
            doc.add((IndexableField)new StringField("synterm", syn.toLowerCase(), Field.Store.NO));
        }
        return doc;
    }

    private TopDocs searchDocumentByWord(String word) throws IOException {
        TopDocs docs = null;
        SynonymIndexSearcher newSynIdxSearcher = this.getNewSynIdxSearcher();
        docs = newSynIdxSearcher.searchDocumentByWord(word);
        newSynIdxSearcher.close();
        return docs;
    }
}

