/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.standardization.index;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Bits;

public class SynonymIndexSearcher {
    private static final Logger LOGGER = Logger.getLogger(SynonymIndexSearcher.class);
    public static final String F_WORD = "word";
    public static final String F_SYN = "syn";
    public static final String F_WORDTERM = "wordterm";
    public static final String F_SYNTERM = "synterm";
    private SearcherManager mgr;
    private int topDocLimit = 3;
    private int maxEdits = 1;
    private static final float WORD_TERM_BOOST = 2.0f;
    private static final float WORD_BOOST = 1.5f;
    private static final int MAX_TOKEN_COUNT_FOR_SEMANTIC_MATCH = 20;
    private Analyzer analyzer;
    private SynonymSearchMode searchMode = SynonymSearchMode.MATCH_ANY;
    private float matchingThreshold = 0.0f;
    private int slop = 1;

    @Deprecated
    public SynonymIndexSearcher() {
    }

    public SynonymIndexSearcher(String indexPath) {
        try {
            this.openIndexInFS(indexPath);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Unable to open synonym index.", (Throwable)e);
        }
    }

    SynonymIndexSearcher(Directory indexDir) throws IOException {
        this.mgr = new SearcherManager(indexDir, null);
    }

    public void openIndexInFS(String path) throws IOException {
        FSDirectory indexDir = FSDirectory.open((File)new File(path));
        this.mgr = new SearcherManager((Directory)indexDir, null);
    }

    public TopDocs searchDocumentByWord(String word) {
        if (word == null) {
            return null;
        }
        String tempWord = word.trim();
        if ("".equals(tempWord)) {
            return null;
        }
        TopDocs docs = null;
        try {
            IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
            Query query = this.createWordQueryFor(tempWord);
            docs = searcher.search(query, this.topDocLimit);
            this.mgr.release((Object)searcher);
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return docs;
    }

    public TopDocs searchDocumentBySynonym(String stringToSearch) throws IOException {
        Query query;
        TopDocs topDocs = null;
        switch (this.searchMode) {
            case MATCH_ANY: {
                query = this.createCombinedQueryFor(stringToSearch, false, false);
                break;
            }
            case MATCH_PARTIAL: {
                query = this.createCombinedQueryForPartialMatch(stringToSearch);
                break;
            }
            case MATCH_ALL: {
                query = this.createCombinedQueryFor(stringToSearch, false, true);
                break;
            }
            case MATCH_EXACT: {
                query = this.createCombinedQueryForExactMatch(stringToSearch);
                break;
            }
            case MATCH_ANY_FUZZY: {
                query = this.createCombinedQueryFor(stringToSearch, true, false);
                break;
            }
            case MATCH_ALL_FUZZY: {
                query = this.createCombinedQueryFor(stringToSearch, true, true);
                break;
            }
            case MATCH_SEMANTIC_DICTIONARY: {
                query = this.createQueryForSemanticDictionaryMatch(stringToSearch);
                break;
            }
            case MATCH_SEMANTIC_KEYWORD: {
                query = this.createQueryForSemanticKeywordMatch(stringToSearch);
                break;
            }
            default: {
                query = this.createCombinedQueryFor(stringToSearch, false, false);
            }
        }
        IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
        topDocs = searcher.search(query, this.topDocLimit);
        this.mgr.release((Object)searcher);
        return topDocs;
    }

    public int getSynonymCount(String word) {
        try {
            Query query = this.createWordQueryFor(word);
            IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
            TopDocs docs = searcher.search(query, this.topDocLimit);
            if (docs.totalHits > 0) {
                Document doc = searcher.doc(docs.scoreDocs[0].doc);
                String[] synonyms = doc.getValues(F_SYN);
                return synonyms.length;
            }
            this.mgr.release((Object)searcher);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        return -1;
    }

    public Document getDocument(int docNum) {
        Document doc = null;
        try {
            IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
            IndexReader reader = searcher.getIndexReader();
            Bits liveDocs = MultiFields.getLiveDocs((IndexReader)reader);
            if (liveDocs != null && !liveDocs.get(docNum)) {
                return null;
            }
            doc = reader.document(docNum);
            this.mgr.release((Object)searcher);
            return doc;
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
            return doc;
        }
    }

    public String getWordByDocNumber(int docNo) {
        Document document = this.getDocument(docNo);
        return document != null ? document.getValues(F_WORD)[0] : null;
    }

    public String[] getSynonymsByDocNumber(int docNo) {
        Document document = this.getDocument(docNo);
        return document != null ? document.getValues(F_SYN) : null;
    }

    public int getNumDocs() {
        try {
            IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
            int numDocs = searcher.getIndexReader().numDocs();
            this.mgr.release((Object)searcher);
            return numDocs;
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public int getMaxDoc() {
        try {
            IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
            int numDocs = searcher.getIndexReader().maxDoc();
            this.mgr.release((Object)searcher);
            return numDocs;
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public int getTopDocLimit() {
        return this.topDocLimit;
    }

    public void setTopDocLimit(int topDocLimit) {
        this.topDocLimit = topDocLimit;
    }

    public int getSlop() {
        return this.slop;
    }

    public void setSlop(int slop) {
        this.slop = slop;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public Analyzer getAnalyzer() {
        if (this.analyzer == null) {
            this.analyzer = new StandardAnalyzer(CharArraySet.EMPTY_SET);
        }
        return this.analyzer;
    }

    private Query createWordQueryFor(String stringToSearch) {
        return new TermQuery(new Term(F_WORDTERM, stringToSearch.toLowerCase()));
    }

    private Query getTermQuery(String field, String text, boolean fuzzy) {
        Term term = new Term(field, text);
        return fuzzy ? new FuzzyQuery(term, this.maxEdits) : new TermQuery(term);
    }

    private Query createCombinedQueryFor(String input, boolean fuzzy, boolean allMatch) throws IOException {
        BooleanQuery combinedQuery = new BooleanQuery();
        Query wordTermQuery = this.getTermQuery(F_WORDTERM, input.toLowerCase(), fuzzy);
        Query synTermQuery = this.getTermQuery(F_SYNTERM, input.toLowerCase(), fuzzy);
        List<String> tokens = SynonymIndexSearcher.getTokensFromAnalyzer(input);
        BooleanQuery wordQuery = new BooleanQuery();
        BooleanQuery synQuery = new BooleanQuery();
        for (String token : tokens) {
            wordQuery.add(this.getTermQuery(F_WORD, token, fuzzy), allMatch ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD);
            synQuery.add(this.getTermQuery(F_SYN, token, fuzzy), allMatch ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD);
        }
        wordTermQuery.setBoost(2.0f);
        wordQuery.setBoost(1.5f);
        combinedQuery.add(wordTermQuery, BooleanClause.Occur.SHOULD);
        combinedQuery.add(synTermQuery, BooleanClause.Occur.SHOULD);
        combinedQuery.add((Query)wordQuery, BooleanClause.Occur.SHOULD);
        combinedQuery.add((Query)synQuery, BooleanClause.Occur.SHOULD);
        return combinedQuery;
    }

    private Query createCombinedQueryForPartialMatch(String input) throws IOException {
        BooleanQuery combinedQuery = new BooleanQuery();
        Query wordTermQuery = this.getTermQuery(F_WORDTERM, input.toLowerCase(), false);
        Query synTermQuery = this.getTermQuery(F_SYNTERM, input.toLowerCase(), false);
        List<String> tokens = SynonymIndexSearcher.getTokensFromAnalyzer(input);
        PhraseQuery wordQuery = new PhraseQuery();
        wordQuery.setSlop(this.slop);
        PhraseQuery synQuery = new PhraseQuery();
        synQuery.setSlop(this.slop);
        for (String token : tokens) {
            token = token.toLowerCase();
            wordQuery.add(new Term(F_WORD, token));
            synQuery.add(new Term(F_SYN, token));
        }
        wordTermQuery.setBoost(2.0f);
        wordQuery.setBoost(1.5f);
        combinedQuery.add(wordTermQuery, BooleanClause.Occur.SHOULD);
        combinedQuery.add(synTermQuery, BooleanClause.Occur.SHOULD);
        combinedQuery.add((Query)wordQuery, BooleanClause.Occur.SHOULD);
        combinedQuery.add((Query)synQuery, BooleanClause.Occur.SHOULD);
        return combinedQuery;
    }

    @Deprecated
    private Query createQueryForSemanticDictionaryMatch(String input) throws IOException {
        List<String> tokens = SynonymIndexSearcher.getTokensFromAnalyzer(input);
        if (tokens.size() > 20) {
            return new TermQuery(new Term(F_SYNTERM, ""));
        }
        Query synTermQuery = this.getTermQuery(F_SYNTERM, StringUtils.join(tokens, (char)' '), false);
        return synTermQuery;
    }

    @Deprecated
    private Query createQueryForSemanticKeywordMatch(String input) throws IOException {
        BooleanQuery booleanQuery = new BooleanQuery();
        List<String> tokens = SynonymIndexSearcher.getTokensFromAnalyzer(input);
        if (tokens.size() > 20) {
            for (int i = 0; i < 20; ++i) {
                booleanQuery.add(this.getTermQuery(F_SYN, tokens.get(i), false), BooleanClause.Occur.SHOULD);
            }
        } else {
            for (String token : tokens) {
                booleanQuery.add(this.getTermQuery(F_SYN, token, false), BooleanClause.Occur.SHOULD);
            }
        }
        return booleanQuery;
    }

    private Query createCombinedQueryForExactMatch(String input) throws IOException {
        BooleanQuery combinedQuery = new BooleanQuery();
        Query wordTermQuery = this.getTermQuery(F_WORDTERM, input.toLowerCase(), false);
        Query synTermQuery = this.getTermQuery(F_SYNTERM, input.toLowerCase(), false);
        wordTermQuery.setBoost(2.0f);
        combinedQuery.add(wordTermQuery, BooleanClause.Occur.SHOULD);
        combinedQuery.add(synTermQuery, BooleanClause.Occur.SHOULD);
        return combinedQuery;
    }

    public void close() {
        try {
            IndexReader indexReader;
            IndexSearcher acquire;
            if (this.mgr != null && (acquire = (IndexSearcher)this.mgr.acquire()) != null && (indexReader = acquire.getIndexReader()) != null) {
                indexReader.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public SynonymSearchMode getSearchMode() {
        return this.searchMode;
    }

    public void setSearchMode(SynonymSearchMode searchMode) {
        this.searchMode = searchMode;
    }

    public void setMaxEdits(int maxEdits) {
        this.maxEdits = maxEdits;
    }

    public float getMatchingThreshold() {
        return this.matchingThreshold;
    }

    public void setMatchingThreshold(float matchingThreshold) {
        this.matchingThreshold = matchingThreshold;
    }

    public void setMatchingThreshold(double matchingThreshold) {
        this.matchingThreshold = (float)matchingThreshold;
    }

    public static List<String> getTokensFromAnalyzer(String input) throws IOException {
        StandardTokenizer tokenStream = new StandardTokenizer((Reader)new StringReader(input));
        StandardFilter result = new StandardFilter((TokenStream)tokenStream);
        result = new LowerCaseFilter((TokenStream)result);
        result = new ASCIIFoldingFilter((TokenStream)result);
        CharTermAttribute charTermAttribute = (CharTermAttribute)result.addAttribute(CharTermAttribute.class);
        tokenStream.reset();
        ArrayList<String> termList = new ArrayList<String>();
        while (result.incrementToken()) {
            String term = charTermAttribute.toString();
            termList.add(term);
        }
        result.close();
        return termList;
    }

    public static enum SynonymSearchMode {
        MATCH_ANY("MATCH_ANY"),
        MATCH_PARTIAL("MATCH_PARTIAL"),
        MATCH_ALL("MATCH_ALL"),
        MATCH_EXACT("MATCH_EXACT"),
        MATCH_ANY_FUZZY("MATCH_ANY_FUZZY"),
        MATCH_ALL_FUZZY("MATCH_ALL_FUZZY"),
        MATCH_SEMANTIC_DICTIONARY("MATCH_SEMANTIC_DICTIONARY"),
        MATCH_SEMANTIC_KEYWORD("MATCH_SEMANTIC_KEYWORD");

        private String label;

        private SynonymSearchMode(String label) {
            this.label = label;
        }

        private String getLabel() {
            return this.label;
        }

        public static SynonymSearchMode get(String label) {
            for (SynonymSearchMode type : SynonymSearchMode.values()) {
                if (!type.getLabel().equalsIgnoreCase(label)) continue;
                return type;
            }
            return MATCH_ANY;
        }
    }
}

