/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.standardization.main;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.talend.dataquality.standardization.index.IndexBuilder;
import org.talend.dataquality.standardization.main.HandleLucene;
import org.talend.dataquality.standardization.query.FirstNameStandardize;

public class HandleLuceneImpl
implements HandleLucene {
    private static final Logger LOG = Logger.getLogger(HandleLuceneImpl.class);
    private static final int HITS_PER_PAGE = 10;
    private Map<String, String[]> hits = new HashMap<String, String[]>();
    private ArrayList<String> soreDoc = null;

    @Override
    public boolean createIndex(String filename, String indexfolder) {
        IndexBuilder idxBuilder = this.getIndexBuilder(indexfolder);
        int[] columnsToBeIndexed = new int[]{0, 1, 2, 3};
        try {
            idxBuilder.initializeIndex(filename, columnsToBeIndexed);
        }
        catch (IOException e) {
            LOG.error((Object)e, (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public String getReplaceSearchResult(String folderName, String inputName, Map<String, String> information2value, boolean fuzzyQuery) throws IOException {
        String result = null;
        if (inputName != null && folderName != null) {
            IndexSearcher searcher = this.getIndexSearcher(folderName);
            Analyzer searchAnalyzer = this.getAnalyzer();
            FirstNameStandardize stdname = new FirstNameStandardize(searcher, searchAnalyzer, 10);
            String countryText = null;
            String genderText = null;
            Set<String> indexKinds = information2value.keySet();
            for (String indexKind : indexKinds) {
                if (indexKind.equals("country")) {
                    countryText = information2value.get(indexKind);
                    continue;
                }
                if (!indexKind.equals("gender")) continue;
                genderText = information2value.get(indexKind);
            }
            try {
                if (countryText == null && genderText == null) {
                    result = stdname.replaceName(inputName, fuzzyQuery);
                } else if (countryText != null && genderText != null) {
                    result = stdname.replaceNameWithCountryGenderInfo(inputName, countryText, genderText, fuzzyQuery);
                } else if (countryText != null && genderText == null) {
                    result = stdname.replaceNameWithCountryInfo(inputName, countryText, fuzzyQuery);
                } else if (countryText == null && genderText != null) {
                    result = stdname.replaceNameWithGenderInfo(inputName, genderText, fuzzyQuery);
                }
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public Map<String, String[]> getSearchResult(String folderName, String inputName, Map<String, String> information2value, boolean fuzzyQuery) throws IOException {
        IndexSearcher searcher = this.getIndexSearcher(folderName);
        Analyzer searchAnalyzer = this.getAnalyzer();
        FirstNameStandardize stdname = new FirstNameStandardize(searcher, searchAnalyzer, 10);
        try {
            ScoreDoc[] docs = stdname.standardize(inputName, information2value, fuzzyQuery);
            this.treatSearchResult(searcher, inputName, docs);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
        searcher.getIndexReader().close();
        return this.getHits();
    }

    private void treatSearchResult(IndexSearcher searcher, String inputName, ScoreDoc[] docs) {
        this.soreDoc = new ArrayList();
        for (ScoreDoc doc : docs) {
            int docId = doc.doc;
            Document d = null;
            try {
                d = searcher.doc(docId);
                String name = d.get("name");
                this.soreDoc.add(name);
            }
            catch (CorruptIndexException e) {
                LOG.error((Object)e, (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        String[] resultArray = new String[this.soreDoc.size()];
        this.hits.put(inputName, this.soreDoc.toArray(resultArray));
    }

    private Map<String, String[]> getHits() {
        return this.hits;
    }

    private Analyzer getAnalyzer() {
        return new StandardAnalyzer();
    }

    private IndexBuilder getIndexBuilder(String folderName) {
        return new IndexBuilder(folderName);
    }

    private IndexSearcher getIndexSearcher(String folderName) {
        FSDirectory dir = null;
        IndexSearcher is = null;
        try {
            dir = FSDirectory.open((File)new File(folderName));
            DirectoryReader reader = DirectoryReader.open((Directory)dir);
            is = new IndexSearcher((IndexReader)reader);
        }
        catch (CorruptIndexException e) {
            LOG.error((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)e, (Throwable)e);
        }
        return is;
    }

    @Override
    public String replaceName(String folderName, String inputName, boolean fuzzyQuery) throws IOException {
        String result = null;
        IndexSearcher searcher = this.getIndexSearcher(folderName);
        Analyzer searchAnalyzer = this.getAnalyzer();
        FirstNameStandardize stdname = new FirstNameStandardize(searcher, searchAnalyzer, 10);
        result = stdname.replaceName(inputName, fuzzyQuery);
        return result;
    }

    @Override
    public String replaceNameWithCountryGenderInfo(String folderName, String inputName, String inputCountry, String inputGender, boolean fuzzyQuery) throws Exception {
        String result = null;
        IndexSearcher searcher = this.getIndexSearcher(folderName);
        Analyzer searchAnalyzer = this.getAnalyzer();
        FirstNameStandardize stdname = new FirstNameStandardize(searcher, searchAnalyzer, 10);
        result = stdname.replaceNameWithCountryGenderInfo(inputName, inputCountry, inputGender, fuzzyQuery);
        return result;
    }

    @Override
    public String replaceNameWithCountryInfo(String folderName, String inputName, String inputCountry, boolean fuzzyQuery) throws Exception {
        String result = null;
        IndexSearcher searcher = this.getIndexSearcher(folderName);
        Analyzer searchAnalyzer = this.getAnalyzer();
        FirstNameStandardize stdname = new FirstNameStandardize(searcher, searchAnalyzer, 10);
        result = stdname.replaceNameWithCountryInfo(inputName, inputCountry, fuzzyQuery);
        return result;
    }

    @Override
    public String replaceNameWithGenderInfo(String folderName, String inputName, String inputGender, boolean fuzzyQuery) throws Exception {
        String result = null;
        IndexSearcher searcher = this.getIndexSearcher(folderName);
        Analyzer searchAnalyzer = this.getAnalyzer();
        FirstNameStandardize stdname = new FirstNameStandardize(searcher, searchAnalyzer, 10);
        result = stdname.replaceNameWithGenderInfo(inputName, inputGender, fuzzyQuery);
        return result;
    }
}

