/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.standardization.phone;

import com.google.i18n.phonenumbers.PhoneNumberToCarrierMapper;
import com.google.i18n.phonenumbers.PhoneNumberToTimeZonesMapper;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.google.i18n.phonenumbers.geocoding.PhoneNumberOfflineGeocoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.talend.dataquality.standardization.phone.PhoneNumberTypeEnum;

public class PhoneNumberHandlerBase {
    private static final Logger LOG = Logger.getLogger(PhoneNumberHandlerBase.class);
    private static PhoneNumberUtil GOOGLE_PHONE_UTIL = PhoneNumberUtil.getInstance();

    protected static Phonenumber.PhoneNumber parseToPhoneNumber(Object data, String regionCode) {
        if (data == null || StringUtils.isBlank((String)data.toString())) {
            return null;
        }
        Phonenumber.PhoneNumber phonenumber = null;
        try {
            phonenumber = GOOGLE_PHONE_UTIL.parse(data.toString(), regionCode);
        }
        catch (Exception e) {
            LOG.error((Object)("Phone number parsing exception with " + data), (Throwable)e);
            return null;
        }
        return phonenumber;
    }

    public static boolean isValidPhoneNumber(Object data, String regionCode) {
        Phonenumber.PhoneNumber phonenumber = null;
        try {
            phonenumber = GOOGLE_PHONE_UTIL.parse(data.toString(), regionCode);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return GOOGLE_PHONE_UTIL.isValidNumberForRegion(phonenumber, regionCode);
    }

    public static boolean isPossiblePhoneNumber(Object data, String regionCode) {
        if (data == null || StringUtils.isBlank((String)data.toString())) {
            return false;
        }
        return GOOGLE_PHONE_UTIL.isPossibleNumber(data.toString(), regionCode);
    }

    public static String formatE164(Object data, String regionCode) {
        Phonenumber.PhoneNumber phonemuber = PhoneNumberHandlerBase.parseToPhoneNumber(data, regionCode);
        if (phonemuber == null) {
            return "";
        }
        return GOOGLE_PHONE_UTIL.format(phonemuber, PhoneNumberUtil.PhoneNumberFormat.E164);
    }

    public static String formatInternational(Object data, String regionCode) {
        Phonenumber.PhoneNumber phonemuber = PhoneNumberHandlerBase.parseToPhoneNumber(data, regionCode);
        if (phonemuber == null) {
            return "";
        }
        return GOOGLE_PHONE_UTIL.format(phonemuber, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL);
    }

    public static String formatNational(Object data, String regionCode) {
        Phonenumber.PhoneNumber phonemuber = PhoneNumberHandlerBase.parseToPhoneNumber(data, regionCode);
        if (phonemuber == null) {
            return "";
        }
        return GOOGLE_PHONE_UTIL.format(phonemuber, PhoneNumberUtil.PhoneNumberFormat.NATIONAL);
    }

    public static String formatRFC396(Object data, String regionCode) {
        Phonenumber.PhoneNumber phonemuber = PhoneNumberHandlerBase.parseToPhoneNumber(data, regionCode);
        if (phonemuber == null) {
            return "";
        }
        return GOOGLE_PHONE_UTIL.format(phonemuber, PhoneNumberUtil.PhoneNumberFormat.RFC3966);
    }

    public static Set<String> getSupportedRegions() {
        return GOOGLE_PHONE_UTIL.getSupportedRegions();
    }

    public static int getCountryCodeForRegion(String regionCode) {
        return GOOGLE_PHONE_UTIL.getCountryCodeForRegion(regionCode);
    }

    public static PhoneNumberTypeEnum getPhoneNumberType(Object data, String regionCode) {
        Phonenumber.PhoneNumber number = PhoneNumberHandlerBase.parseToPhoneNumber(data, regionCode);
        if (number != null) {
            PhoneNumberUtil.PhoneNumberType numberType = GOOGLE_PHONE_UTIL.getNumberType(number);
            switch (numberType) {
                case FIXED_LINE: {
                    return PhoneNumberTypeEnum.FIXED_LINE;
                }
                case MOBILE: {
                    return PhoneNumberTypeEnum.MOBILE;
                }
                case FIXED_LINE_OR_MOBILE: {
                    return PhoneNumberTypeEnum.FIXED_LINE_OR_MOBILE;
                }
                case PAGER: {
                    return PhoneNumberTypeEnum.PAGER;
                }
                case PERSONAL_NUMBER: {
                    return PhoneNumberTypeEnum.PERSONAL_NUMBER;
                }
                case TOLL_FREE: {
                    return PhoneNumberTypeEnum.TOLL_FREE;
                }
                case PREMIUM_RATE: {
                    return PhoneNumberTypeEnum.PREMIUM_RATE;
                }
                case SHARED_COST: {
                    return PhoneNumberTypeEnum.SHARED_COST;
                }
                case UAN: {
                    return PhoneNumberTypeEnum.UAN;
                }
                case VOICEMAIL: {
                    return PhoneNumberTypeEnum.VOICEMAIL;
                }
                case VOIP: {
                    return PhoneNumberTypeEnum.VOIP;
                }
            }
        }
        return PhoneNumberTypeEnum.UNKNOWN;
    }

    public static boolean containsValidRegionCode(Object data) {
        String regionCode = PhoneNumberHandlerBase.extractRegionCode(data);
        return regionCode != null && PhoneNumberHandlerBase.getSupportedRegions().contains(regionCode);
    }

    public static String extractRegionCode(Object phoneData) {
        Phonenumber.PhoneNumber phoneNumber = PhoneNumberHandlerBase.parseToPhoneNumber(phoneData, null);
        if (phoneNumber != null) {
            return GOOGLE_PHONE_UTIL.getRegionCodeForNumber(phoneNumber);
        }
        return "";
    }

    public static int extractCountrycode(Object phoneData) {
        Phonenumber.PhoneNumber phoneNumber = PhoneNumberHandlerBase.parseToPhoneNumber(phoneData, null);
        if (phoneNumber != null) {
            return phoneNumber.getCountryCode();
        }
        return 0;
    }

    public static String getGeocoderDescriptionForNumber(Object data, String regionCode, Locale languageCode) {
        Phonenumber.PhoneNumber number = PhoneNumberHandlerBase.parseToPhoneNumber(data, regionCode);
        if (number != null) {
            return PhoneNumberOfflineGeocoder.getInstance().getDescriptionForNumber(number, languageCode);
        }
        return "";
    }

    public static String getCarrierNameForNumber(Object data, String regionCode, Locale languageCode) {
        Phonenumber.PhoneNumber number = PhoneNumberHandlerBase.parseToPhoneNumber(data, regionCode);
        if (number == null) {
            return "";
        }
        return PhoneNumberToCarrierMapper.getInstance().getNameForNumber(number, languageCode);
    }

    public static List<String> getTimeZonesForNumber(Object data, String regionCode) {
        Phonenumber.PhoneNumber number = PhoneNumberHandlerBase.parseToPhoneNumber(data, regionCode);
        if (number == null) {
            ArrayList<String> unknowTimeZoneLs = new ArrayList<String>(1);
            unknowTimeZoneLs.add(PhoneNumberToTimeZonesMapper.getUnknownTimeZone());
            return unknowTimeZoneLs;
        }
        return PhoneNumberToTimeZonesMapper.getInstance().getTimeZonesForNumber(number);
    }
}

