/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.standardization.query;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;

public class FirstNameStandardize {
    private static final Logger LOG = Logger.getLogger(FirstNameStandardize.class);
    @Deprecated
    private static final float MATCHING_SIMILARITY = 0.74f;
    private int maxEdits = 1;
    private Analyzer analyzer;
    private IndexSearcher searcher;
    private int hitsPerPage;
    public static final boolean SORT_WITH_COUNT = true;

    public FirstNameStandardize(IndexSearcher indexSearcher, Analyzer analyzer, int hitsPerPage) throws IOException {
        assert (analyzer != null);
        assert (indexSearcher != null);
        this.analyzer = analyzer;
        this.searcher = indexSearcher;
        this.hitsPerPage = hitsPerPage;
    }

    @Deprecated
    private ScoreDoc[] standardize(String input, boolean fuzzyQuery) throws ParseException, IOException {
        if (input == null || input.length() == 0) {
            return new ScoreDoc[0];
        }
        ScoreDoc[] matches = null;
        if (fuzzyQuery) {
            try {
                matches = this.getFuzzySearch((String)input).scoreDocs;
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
        } else {
            Query q = new QueryParser("name", this.analyzer).parse(input);
            matches = this.searcher.search((Query)q, (int)10).scoreDocs;
        }
        return matches;
    }

    public void getFuzzySearch(String input, TopDocsCollector<?> collector) throws Exception {
        FuzzyQuery q = new FuzzyQuery(new Term("name", input));
        FuzzyQuery qalias = new FuzzyQuery(new Term("alias", input));
        BooleanQuery combinedQuery = new BooleanQuery();
        combinedQuery.add((Query)q, BooleanClause.Occur.SHOULD);
        combinedQuery.add((Query)qalias, BooleanClause.Occur.SHOULD);
        this.searcher.search((Query)combinedQuery, collector);
    }

    private TopDocs getFuzzySearch(String input) throws Exception {
        FuzzyQuery q = new FuzzyQuery(new Term("name", input.toLowerCase()), this.maxEdits);
        TopDocs matches = this.searcher.search((Query)q, 10);
        return matches;
    }

    private Query getTermQuery(String field, String text, boolean fuzzy) {
        Term term = new Term(field, text);
        return fuzzy ? new FuzzyQuery(term, this.maxEdits) : new TermQuery(term);
    }

    private List<String> getTokensFromAnalyzer(String input) throws IOException {
        StandardTokenizer tokenStream = new StandardTokenizer((Reader)new StringReader(input));
        StandardFilter result = new StandardFilter((TokenStream)tokenStream);
        result = new LowerCaseFilter((TokenStream)result);
        CharTermAttribute charTermAttribute = (CharTermAttribute)result.addAttribute(CharTermAttribute.class);
        tokenStream.reset();
        ArrayList<String> termList = new ArrayList<String>();
        while (result.incrementToken()) {
            String term = charTermAttribute.toString();
            termList.add(term);
        }
        result.close();
        return termList;
    }

    public ScoreDoc[] standardize(String inputName, Map<String, String> information2value, boolean fuzzySearch) throws IOException {
        if (inputName == null || inputName.length() == 0) {
            return new ScoreDoc[0];
        }
        String countryText = null;
        String genderText = null;
        if (information2value != null) {
            countryText = information2value.get("country");
            genderText = information2value.get("gender");
        }
        BooleanQuery combinedQuery = new BooleanQuery();
        BooleanQuery nameQueries = new BooleanQuery();
        List<String> tokens = this.getTokensFromAnalyzer(inputName);
        for (String token : tokens) {
            Query termQuery = this.getTermQuery("name", token, false);
            termQuery.setBoost(2.0f);
            nameQueries.add(termQuery, BooleanClause.Occur.SHOULD);
        }
        Query nameTermQuery = this.getTermQuery("nameterm", inputName.toLowerCase(), fuzzySearch);
        nameQueries.add(nameTermQuery, BooleanClause.Occur.SHOULD);
        combinedQuery.add((Query)nameQueries, BooleanClause.Occur.MUST);
        if (countryText != null && !"".equals(countryText)) {
            Query countryQuery = this.getTermQuery("country", countryText, false);
            countryQuery.setBoost(5.0f);
            combinedQuery.add(countryQuery, BooleanClause.Occur.SHOULD);
        }
        if (genderText != null && !"".equals(genderText)) {
            Query genderQuery = this.getTermQuery("gender", genderText, false);
            genderQuery.setBoost(5.0f);
            combinedQuery.add(genderQuery, BooleanClause.Occur.SHOULD);
        }
        TopDocs matches = this.searcher.search((Query)combinedQuery, 10);
        return matches.scoreDocs;
    }

    private TopDocsCollector<?> createTopDocsCollector() throws IOException {
        SortField sortfield = new SortField("count", SortField.Type.INT);
        Sort sort = new Sort(sortfield);
        return TopFieldCollector.create((Sort)sort, (int)this.hitsPerPage, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
    }

    public String replaceName(String inputName, boolean fuzzyQuery) throws IOException {
        ScoreDoc[] results = this.standardize(inputName, null, fuzzyQuery);
        return results.length == 0 ? "" : this.searcher.doc(results[0].doc).get("name");
    }

    public String replaceNameWithCountryGenderInfo(String inputName, String inputCountry, String inputGender, boolean fuzzyQuery) throws IOException {
        HashMap<String, String> indexFields = new HashMap<String, String>();
        indexFields.put("country", inputCountry);
        indexFields.put("gender", inputGender);
        ScoreDoc[] results = this.standardize(inputName, indexFields, fuzzyQuery);
        return results.length == 0 ? "" : this.searcher.doc(results[0].doc).get("name");
    }

    public String replaceNameWithCountryInfo(String inputName, String inputCountry, boolean fuzzyQuery) throws IOException {
        HashMap<String, String> indexFields = new HashMap<String, String>();
        indexFields.put("country", inputCountry);
        ScoreDoc[] results = this.standardize(inputName, indexFields, fuzzyQuery);
        return results.length == 0 ? "" : this.searcher.doc(results[0].doc).get("name");
    }

    public String replaceNameWithGenderInfo(String inputName, String inputGender, boolean fuzzyQuery) throws IOException {
        HashMap<String, String> indexFields = new HashMap<String, String>();
        indexFields.put("gender", inputGender);
        ScoreDoc[] results = this.standardize(inputName, indexFields, fuzzyQuery);
        return results.length == 0 ? "" : this.searcher.doc(results[0].doc).get("name");
    }

    public void setMaxEdits(int maxEdits) {
        this.maxEdits = maxEdits;
    }
}

