/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.standardization.record;

import org.apache.commons.lang.builder.HashCodeBuilder;

public class OutputRecord
implements Comparable<OutputRecord> {
    String[] record;
    float score = 0.0f;
    String scores;
    int nbMatch = 0;

    public OutputRecord(int size) {
        this.record = new String[size];
        this.scores = "";
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (String element : this.record) {
            buf.append(element).append(" ; ");
        }
        buf.deleteCharAt(buf.length() - 2);
        buf.append(" | score= " + this.score);
        buf.append(" ->" + this.scores).append("| nb match=").append(this.nbMatch).append("/").append(this.record.length);
        return buf.toString();
    }

    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object[])this.record);
        return b.toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OutputRecord)) {
            return false;
        }
        OutputRecord other = (OutputRecord)obj;
        for (int i = 0; i < this.record.length; ++i) {
            if (!(this.record[i] == null ? other.record[i] != null : !this.record[i].equals(other.record[i]))) continue;
            return false;
        }
        return true;
    }

    public String[] getRecord() {
        return this.record;
    }

    public String getRecord(int index) {
        assert (index >= 0 && index < this.record.length);
        return this.record[index];
    }

    public int getNbMatch() {
        return this.nbMatch;
    }

    public float getScore() {
        return this.score;
    }

    public String getScores() {
        if (this.scores != null && this.scores.startsWith("|")) {
            this.scores = this.scores.substring(1);
        }
        return this.scores;
    }

    @Override
    public int compareTo(OutputRecord o) {
        return -((int)(100.0f * (this.score - o.score)));
    }
}

