/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.standardization.record;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.talend.dataquality.standardization.index.SynonymIndexSearcher;
import org.talend.dataquality.standardization.record.OutputRecord;

public class SynonymRecordSearcher {
    private static final Logger LOG = Logger.getLogger(SynonymRecordSearcher.class);
    private SynonymIndexSearcher[] searchers;
    private int recordSize = 0;

    public SynonymRecordSearcher(int size) {
        this.recordSize = size;
        this.searchers = new SynonymIndexSearcher[this.recordSize];
    }

    public List<OutputRecord> search(int maxNbOutputResults, String[] record) throws IOException {
        assert (record != null);
        RecordResult recRes = new RecordResult();
        for (int i = 0; i < record.length; ++i) {
            ArrayList<WordResult> wResults = new ArrayList<WordResult>();
            String field = record[i];
            if (field == null || "".equals(field.trim())) {
                wResults.add(SynonymRecordSearcher.createEmptyWordResult(field));
            } else {
                SynonymIndexSearcher searcher = this.searchers[i];
                TopDocs docs = searcher.searchDocumentBySynonym(field);
                int nbDocs = Math.min(searcher.getTopDocLimit(), docs.totalHits);
                for (int j = 0; j < nbDocs; ++j) {
                    ScoreDoc scoreDoc = docs.scoreDocs[j];
                    if (!(scoreDoc.score > searcher.getMatchingThreshold())) continue;
                    String foundWord = searcher.getWordByDocNumber(scoreDoc.doc);
                    WordResult wordRes = new WordResult();
                    wordRes.input = field;
                    wordRes.word = foundWord;
                    wordRes.score = scoreDoc.score;
                    wResults.add(wordRes);
                }
                if (wResults.isEmpty()) {
                    WordResult wordRes = SynonymRecordSearcher.createEmptyWordResult(field);
                    wResults.add(wordRes);
                }
            }
            recRes.record = record;
            recRes.wordResults.add(wResults);
        }
        List<OutputRecord> outputRecords = recRes.computeOutputRows();
        Collections.sort(outputRecords);
        int tempMaxNbOutputResults = Math.min(outputRecords.isEmpty() ? 0 : outputRecords.size(), maxNbOutputResults);
        return outputRecords.subList(0, tempMaxNbOutputResults);
    }

    public void addSearcher(SynonymIndexSearcher searcher, int columnIndex) {
        assert (columnIndex < this.recordSize);
        if (searcher == null) {
            LOG.error((Object)("SynonymRecordSearcher.tried" + columnIndex));
        }
        this.searchers[columnIndex] = searcher;
    }

    public SynonymIndexSearcher getSearcher(int columnIndex) {
        return this.searchers[columnIndex];
    }

    private static WordResult createEmptyWordResult(String input) {
        WordResult emptyWordResult = new WordResult();
        emptyWordResult.input = input;
        emptyWordResult.score = 0.0f;
        emptyWordResult.word = null;
        return emptyWordResult;
    }

    static class RecordResult {
        String[] record;
        final List<List<WordResult>> wordResults = new ArrayList<List<WordResult>>();

        RecordResult() {
        }

        public List<OutputRecord> computeOutputRows() {
            HashSet<OutputRecord> outputRecords = new HashSet<OutputRecord>();
            RecordResult.computeOutputRows(this.record.length, new ArrayList<WordResult>(), this.wordResults, outputRecords);
            return new ArrayList<OutputRecord>(outputRecords);
        }

        static void computeOutputRows(int recordLength, List<WordResult> foundWords, List<List<WordResult>> wrs, Collection<OutputRecord> outputRows) {
            assert (!wrs.isEmpty());
            if (wrs.size() == 1) {
                List<WordResult> lastWR = wrs.get(0);
                if (lastWR.isEmpty()) {
                    outputRows.add(RecordResult.createOutputRecord(recordLength, foundWords, SynonymRecordSearcher.createEmptyWordResult("")));
                } else {
                    for (WordResult wordResult : lastWR) {
                        outputRows.add(RecordResult.createOutputRecord(recordLength, foundWords, wordResult));
                    }
                }
            } else {
                List<WordResult> firstWR = wrs.get(0);
                List<List<WordResult>> sublist = wrs.subList(1, wrs.size());
                if (firstWR.isEmpty()) {
                    ArrayList<WordResult> wr = new ArrayList<WordResult>(foundWords);
                    wr.add(SynonymRecordSearcher.createEmptyWordResult(""));
                    RecordResult.computeOutputRows(recordLength, wr, sublist, outputRows);
                }
                for (WordResult wordResult : firstWR) {
                    ArrayList<WordResult> wr = new ArrayList<WordResult>(foundWords);
                    wr.add(wordResult);
                    RecordResult.computeOutputRows(recordLength, wr, sublist, outputRows);
                }
            }
        }

        private static OutputRecord createOutputRecord(int recordLength, List<WordResult> foundWords, WordResult currentWordResult) {
            OutputRecord outputRec = new OutputRecord(recordLength);
            for (int i = 0; i < foundWords.size(); ++i) {
                RecordResult.updateOutputRec(outputRec, i, foundWords.get(i));
            }
            RecordResult.updateOutputRec(outputRec, foundWords.size(), currentWordResult);
            return outputRec;
        }

        private static void updateOutputRec(OutputRecord outputRec, int idx, WordResult wordResult) {
            outputRec.record[idx] = wordResult.word;
            outputRec.score += wordResult.score;
            outputRec.scores = outputRec.scores + "|" + wordResult.score;
            if (Float.compare(wordResult.score, 0.0f) != 0) {
                ++outputRec.nbMatch;
            }
        }
    }

    static class WordResult {
        String input;
        String word;
        float score;

        WordResult() {
        }

        public String toString() {
            return "WordResult=" + this.input + "->" + this.word + "; score=" + this.score;
        }
    }
}

