/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.cardinality;

import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import java.util.List;
import org.talend.dataquality.common.inference.Analyzer;
import org.talend.dataquality.common.inference.ResizableList;
import org.talend.dataquality.statistics.cardinality.CardinalityHLLStatistics;

public class CardinalityHLLAnalyzer
implements Analyzer<CardinalityHLLStatistics> {
    private static final long serialVersionUID = -5813206492367921798L;
    int rsd = 20;
    private ResizableList<CardinalityHLLStatistics> cardinalityStatistics = null;

    public void init() {
        this.cardinalityStatistics = new ResizableList(CardinalityHLLStatistics.class);
    }

    public void setRelativeStandardDeviation(int rsd) {
        this.rsd = rsd;
    }

    public boolean analyze(String ... record) {
        if (record == null) {
            return true;
        }
        this.cardinalityStatistics.resize(record.length);
        for (int i = 0; i < record.length; ++i) {
            CardinalityHLLStatistics cardStats = (CardinalityHLLStatistics)this.cardinalityStatistics.get(i);
            if (cardStats.getHyperLogLog() == null) {
                cardStats.setHyperLogLog(new HyperLogLog(this.rsd));
            }
            cardStats.add(record[i]);
            cardStats.incrementCount();
        }
        return true;
    }

    public void end() {
    }

    public List<CardinalityHLLStatistics> getResult() {
        return this.cardinalityStatistics;
    }

    public void close() throws Exception {
    }
}

