/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.datetime;

import java.time.chrono.HijrahChronology;
import java.time.chrono.JapaneseChronology;
import java.time.chrono.MinguoChronology;
import java.time.chrono.ThaiBuddhistChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ChronologyParameterManager {
    private static final Locale DEFAULT_LOCALE = Locale.US;
    private static Map<String, Locale> localeEraMap = null;

    private ChronologyParameterManager() {
    }

    public static Locale guessLocaleByEra(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return DEFAULT_LOCALE;
        }
        int indexOf = value.indexOf(32);
        if (indexOf != -1) {
            ChronologyParameterManager.initMapIfNeeded();
            String era = value.substring(indexOf + 1, value.length());
            Locale locale = localeEraMap.get(era);
            if (locale != null) {
                return locale;
            }
        }
        return DEFAULT_LOCALE;
    }

    private static void initMapIfNeeded() {
        if (localeEraMap == null) {
            localeEraMap = new HashMap<String, Locale>();
            Locale localeTH = new Locale("th");
            localeEraMap.put("AD", Locale.US);
            localeEraMap.put("BC", Locale.US);
            localeEraMap.put("\u660e\u6cbb", Locale.JAPANESE);
            localeEraMap.put("\u5e73\u6210", Locale.JAPANESE);
            localeEraMap.put("\u662d\u548c", Locale.JAPANESE);
            localeEraMap.put("\u5927\u6b63", Locale.JAPANESE);
            localeEraMap.put("\u0647\u0640", new Locale("ar"));
            localeEraMap.put("\u6c11\u570b", Locale.TRADITIONAL_CHINESE);
            localeEraMap.put("\u6c11\u570b\u524d", Locale.TRADITIONAL_CHINESE);
            localeEraMap.put("\u0e1e.\u0e28.", localeTH);
            localeEraMap.put("\u0e1b\u0e35\u0e01\u0e48\u0e2d\u0e19\u0e04\u0e23\u0e34\u0e2a\u0e15\u0e4c\u0e01\u0e32\u0e25\u0e17\u0e35\u0e48", localeTH);
        }
    }

    public static DateTimeFormatter getDateTimeFormatterWithChronology(String pattern, Locale locale) {
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern(pattern).toFormatter(locale).withResolverStyle(ResolverStyle.STRICT);
        if (Locale.JAPANESE.equals(locale)) {
            return formatter.withChronology(JapaneseChronology.INSTANCE);
        }
        if (Locale.TRADITIONAL_CHINESE.equals(locale)) {
            return formatter.withChronology(MinguoChronology.INSTANCE);
        }
        if ("ar".equals(locale.getLanguage())) {
            return formatter.withChronology(HijrahChronology.INSTANCE);
        }
        if ("th".equals(locale.getLanguage())) {
            return formatter.withChronology(ThaiBuddhistChronology.INSTANCE).withLocale(locale);
        }
        return formatter;
    }
}

